/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.apiary;

import binnie.extrabees.apiary.ItemHiveFrame;
import binnie.extrabees.config.ConfigurationMain;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IHiveFrame;
import forestry.api.core.ItemInterface;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum EnumHiveFrame implements IHiveFrame
{
    Cocoa("Chocolate Frame"),
    Cage("Restraint Frame"),
    Soul("Soul Frame"),
    Clay("Healing Frame"),
    Debug("Nova Frame");

    Item item;
    float mutation = 1.0f;
    float territory = 1.0f;
    float lifespan = 1.0f;
    float production = 1.0f;
    float mutationCap = 1.0f;
    float territoryCap = 1.0f;
    float lifespanCap = 1.0f;
    float productionCap = 1.0f;
    int maxDamage = 240;
    String name;

    public static void init() {
        Cocoa.setLifespan(0.75f, 0.5f);
        Cocoa.setProduction(1.5f, 10.0f);
        Cage.setTerritory(0.5f, 0.1f);
        Cage.setLifespan(0.75f, 0.5f);
        Cage.setProduction(0.75f, 0.5f);
        Soul.setMutation(1.5f, 5.0f);
        Soul.setLifespan(0.75f, 0.5f);
        Soul.setProduction(0.25f, 0.1f);
        Soul.setMaxDamage(80);
        Clay.setLifespan(1.5f, 5.0f);
        Clay.setMutation(0.5f, 0.2f);
        Clay.setProduction(0.75f, 0.2f);
        Debug.setLifespan(1.0E-4f, 1.0E-4f);
        for (EnumHiveFrame frame : EnumHiveFrame.values()) {
            frame.item = new ItemHiveFrame(frame);
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(EnumHiveFrame.Cocoa.item), (Object[])new Object[]{" c ", "cFc", " c ", Character.valueOf('F'), ItemInterface.getItem((String)"frameImpregnated"), Character.valueOf('c'), new ItemStack(Item.field_77756_aW, 1, 3)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(EnumHiveFrame.Cage.item), (Object[])new Object[]{ItemInterface.getItem((String)"frameImpregnated"), Block.field_72002_bp});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(EnumHiveFrame.Soul.item), (Object[])new Object[]{ItemInterface.getItem((String)"frameImpregnated"), Block.field_72013_bc});
        GameRegistry.addRecipe((ItemStack)new ItemStack(EnumHiveFrame.Clay.item), (Object[])new Object[]{" c ", "cFc", " c ", Character.valueOf('F'), ItemInterface.getItem((String)"frameImpregnated"), Character.valueOf('c'), Item.field_77757_aI});
    }

    public int getIconIndex() {
        return 55 + this.ordinal();
    }

    public int getItemID() {
        switch (this) {
            case Cocoa: {
                return ConfigurationMain.hiveFrameID;
            }
            case Cage: {
                return ConfigurationMain.hiveFrame2ID;
            }
            case Soul: {
                return ConfigurationMain.hiveFrame3ID;
            }
            case Clay: {
                return ConfigurationMain.hiveFrame4ID;
            }
            case Debug: {
                return ConfigurationMain.hiveFrame5ID;
            }
        }
        return ConfigurationMain.hiveFrameID;
    }

    public void setMutation(float mutation, float cap) {
        this.mutation = mutation;
        this.mutationCap = cap;
    }

    public void setTerritory(float territory, float cap) {
        this.territory = territory;
        this.territoryCap = cap;
    }

    public void setLifespan(float lifespan, float cap) {
        this.lifespan = lifespan;
        this.lifespanCap = cap;
    }

    public void setProduction(float production, float cap) {
        this.production = production;
        this.productionCap = cap;
    }

    public void setMaxDamage(int damage) {
        this.maxDamage = damage;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumHiveFrame() {
        void name;
        this.name = name;
    }

    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        if (this.territoryCap > 1.0f) {
            return Math.min(this.territory, this.territoryCap / currentModifier);
        }
        return Math.max(this.territory, this.territoryCap / currentModifier);
    }

    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        if (this.mutationCap > 1.0f) {
            return Math.min(this.mutation, this.mutationCap / currentModifier);
        }
        return Math.max(this.mutation, this.mutationCap / currentModifier);
    }

    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        if (this.lifespanCap > 1.0f) {
            return Math.min(this.lifespan, this.lifespanCap / currentModifier);
        }
        return Math.max(this.lifespan, this.lifespanCap / currentModifier);
    }

    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        if (this.productionCap > 1.0f) {
            return Math.min(this.production, this.productionCap / currentModifier);
        }
        return Math.max(this.production, this.productionCap / currentModifier);
    }

    public ItemStack frameUsed(IBeeHousing house, ItemStack frame, IBee queen, int wear) {
        frame.func_77964_b(frame.func_77960_j() + wear);
        if (frame.func_77960_j() >= frame.func_77958_k()) {
            return null;
        }
        return frame;
    }

    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        return 1.0f;
    }

    public boolean isSealed() {
        return false;
    }

    public boolean isSelfLighted() {
        return false;
    }

    public boolean isSunlightSimulated() {
        return false;
    }

    public boolean isHellish() {
        return false;
    }
}

