/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.mod.database;

import binnie.core.genetics.BreedingSystem;
import binnie.craftgui.controls.button.ControlEnumButton;
import binnie.craftgui.controls.core.IControlValue;
import binnie.craftgui.controls.listbox.ControlList;
import binnie.craftgui.controls.page.ControlPage;
import binnie.craftgui.controls.page.ControlPages;
import binnie.craftgui.controls.tab.ControlTabBar;
import binnie.craftgui.controls.tab.ControlTabBarWidget;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.CraftGUIUtil;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventValueChanged;
import binnie.craftgui.events.core.EventHandler;
import binnie.craftgui.minecraft.MinecraftGUI;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.mod.database.ControlBranchBox;
import binnie.craftgui.mod.database.ControlSpeciesBox;
import binnie.craftgui.mod.database.EventBranchChanged;
import binnie.craftgui.mod.database.EventSpeciesChanged;
import binnie.craftgui.mod.database.PageBreeder;
import binnie.craftgui.mod.database.PageBreederStats;
import binnie.craftgui.window.Panel;
import cpw.mods.fml.relauncher.Side;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IClassification;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public abstract class WindowAbstractDatabase
extends Window {
    protected float selectionBoxWidth = 95.0f;
    protected final float infoBoxWidth = 95.0f;
    boolean isNEI;
    BreedingSystem system;
    Panel panelInformation = null;
    Panel panelSearch = null;
    protected ControlPages modePages = null;
    ControlPage modeBreeder;
    ControlPage modeSpecies;
    ControlPage modeBranches;
    protected ControlPages branchPages = null;
    protected ControlPages speciesPages = null;
    ControlTabBar branchTabBar;
    ControlTabBar speciesTabBar;
    ControlEnumButton modeButton = null;
    ControlBranchBox selectionBoxBranches;
    ControlSpeciesBox selectionBoxSpecies;
    PageBreeder pageBreeder;
    PageBreederStats pageBreederStats;
    private IAlleleSpecies gotoSpecies = null;

    public void changeMode(Mode mode) {
        this.modePages.setValue((Object)mode);
        if (mode == Mode.Breeder) {
            // empty if block
        }
        this.pageBreeder.onPageRefresh();
    }

    @EventHandler(origin=EventHandler.Origin.Any)
    public void onValueChanged(EventValueChanged event) {
        IAlleleSpecies selection;
        if (this.speciesPages == null || this.branchPages == null) {
            return;
        }
        if (event.isOrigin(this.modeButton)) {
            Mode mode = (Mode)((Object)event.getValue());
            this.changeMode(mode);
        }
        if (event.isOrigin(this.selectionBoxSpecies)) {
            selection = (IAlleleSpecies)event.getValue();
            if (selection == null) {
                this.speciesPages.hide();
            } else {
                this.speciesPages.show();
                this.callEvent(new EventSpeciesChanged(this, selection));
            }
        }
        if (event.isOrigin(this.selectionBoxBranches)) {
            selection = (IClassification)event.getValue();
            if (selection == null) {
                this.branchPages.hide();
            } else {
                this.branchPages.show();
                this.callEvent(new EventBranchChanged(this, (IClassification)selection));
            }
        }
    }

    public boolean isNEI() {
        return this.isNEI;
    }

    public BreedingSystem getBreedingSystem() {
        return this.system;
    }

    public WindowAbstractDatabase(EntityPlayer player, Side side, boolean nei, BreedingSystem system, float wid) {
        super(185.0f + wid, 192.0f, player, null, side);
        this.isNEI = nei;
        this.system = system;
        this.selectionBoxWidth = wid;
    }

    public WindowAbstractDatabase(EntityPlayer player, Side side, boolean nei, BreedingSystem system) {
        this(player, side, nei, system, 95.0f);
    }

    @Override
    public void initialize() {
        IBreedingTracker tracker;
        this.panelInformation = new Panel(this, 24.0f, 8.0f, 144.0f, 176.0f, MinecraftGUI.PanelType.Black);
        this.panelInformation.setColour(860416);
        this.panelSearch = new Panel(this, 172.0f, 32.0f, this.selectionBoxWidth + 5.0f, 151.0f, MinecraftGUI.PanelType.Black);
        this.panelSearch.setColour(860416);
        this.modeButton = new ControlEnumButton((IWidget)this, 172.0f, 8.0f, this.selectionBoxWidth + 5.0f, 20.0f, Mode.class);
        this.modePages = new ControlPages(this, 0.0f, 0.0f, this.getSize().x(), this.getSize().y());
        this.modeSpecies = new ControlPage(this.modePages, 0.0f, 0.0f, this.getSize().x(), this.getSize().y(), (Object)Mode.Species);
        this.modeBranches = new ControlPage(this.modePages, 0.0f, 0.0f, this.getSize().x(), this.getSize().y(), (Object)Mode.Branches);
        this.modeBreeder = new ControlPage(this.modePages, 0.0f, 0.0f, this.getSize().x(), this.getSize().y(), (Object)Mode.Breeder);
        this.modePages.addChild(this.modeSpecies);
        this.modePages.addChild(this.modeBranches);
        this.modePages.addChild(this.modeBreeder);
        this.pageBreeder = new PageBreeder(this.modeBreeder, this.getPlayer() == null ? "" : this.getPlayer().field_71092_bJ);
        this.pageBreederStats = new PageBreederStats(this.modeBreeder, (int)(this.selectionBoxWidth + 5.0f), 151, this.getPlayer() == null ? "" : this.getPlayer().field_71092_bJ);
        CraftGUIUtil.alignToWidget(this.pageBreeder, this.panelInformation);
        CraftGUIUtil.alignToWidget(this.pageBreederStats, this.panelSearch);
        this.setupSpeciesView();
        this.setupBranchView();
        this.addTabs();
        for (IControlValue page : this.speciesPages.getPages()) {
            CraftGUIUtil.alignToWidget(page, this.panelInformation);
        }
        for (IControlValue page : this.branchPages.getPages()) {
            CraftGUIUtil.alignToWidget(page, this.panelInformation);
        }
        this.speciesTabBar = new ControlTabBarWidget(this.modeSpecies, 8, 8, 16, 176, this.speciesPages);
        this.branchTabBar = new ControlTabBarWidget(this.modeBranches, 8, 8, 16, 176, this.branchPages);
        this.changeMode(Mode.Species);
        if (this.selectionBoxSpecies.getValue() == null && ((ControlList)this.selectionBoxSpecies.getContent()).getOptions().size() > 0) {
            this.selectionBoxSpecies.setValue(((ControlList)this.selectionBoxSpecies.getContent()).getOptions().iterator().next());
        }
        if (this.isServer() && (tracker = this.system.getSpeciesRoot().getBreedingTracker(this.getWorld(), this.getPlayer() == null ? "" : this.getPlayer().field_71092_bJ)) != null) {
            tracker.synchToPlayer(this.getPlayer());
        }
    }

    protected void addTabs() {
    }

    public void setupSpeciesView() {
        EntityPlayer player = this.getPlayer();
        String playerName = player == null ? "" : player.field_71092_bJ;
        Collection speciesList = !this.isNEI ? this.system.getDiscoveredSpecies(this.getWorld(), playerName) : this.system.getAllSpecies();
        this.selectionBoxSpecies = new ControlSpeciesBox(this.modeSpecies, 2.0f, 2.0f, this.selectionBoxWidth, 147.0f);
        this.selectionBoxSpecies.setOptions(speciesList);
        CraftGUIUtil.alignToWidget(this.selectionBoxSpecies, this.panelSearch);
        CraftGUIUtil.moveWidget(this.selectionBoxSpecies, new Vector2f(2.0f, 2.0f));
        this.speciesPages = new ControlPages(this.modeSpecies, 0.0f, 0.0f, 144.0f, 176.0f);
    }

    public void setupBranchView() {
        EntityPlayer player = this.getPlayer();
        String playerName = player == null ? "" : player.field_71092_bJ;
        List branchList = !this.isNEI ? this.system.getDiscoveredBranches(this.getWorld(), playerName) : this.system.getAllBranches();
        this.selectionBoxBranches = new ControlBranchBox(this.modeBranches, 2.0f, 2.0f, this.selectionBoxWidth, 147.0f);
        this.selectionBoxBranches.setOptions(branchList);
        CraftGUIUtil.alignToWidget(this.selectionBoxBranches, this.panelSearch);
        CraftGUIUtil.moveWidget(this.selectionBoxBranches, new Vector2f(2.0f, 2.0f));
        this.branchPages = new ControlPages(this.modeBranches, 0.0f, 0.0f, 144.0f, 176.0f);
    }

    public void gotoSpecies(IAlleleSpecies value) {
        if (value != null) {
            this.modeButton.setValue(Mode.Species);
            this.changeMode(Mode.Species);
            this.selectionBoxSpecies.setValue(value);
        }
    }

    public void gotoSpeciesDelayed(IAlleleSpecies species) {
        this.gotoSpecies = species;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.gotoSpecies != null) {
            ((WindowAbstractDatabase)this.getSuperParent()).gotoSpecies(this.gotoSpecies);
            this.gotoSpecies = null;
        }
    }

    public static enum Mode {
        Species,
        Branches,
        Breeder;

    }
}

