/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft;

import binnie.core.BinnieCore;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.Direction;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPosition;
import binnie.craftgui.core.geometry.TextJustification;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.core.renderer.IRendererWidget;
import binnie.craftgui.events.EventKey;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.minecraft.IRendererMinecraft;
import binnie.craftgui.minecraft.MinecraftTooltip;
import binnie.craftgui.minecraft.RendererWidgetMinecraft;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.resource.ITexture;
import binnie.craftgui.resource.ITexturePadded;
import binnie.craftgui.resource.minecraft.CraftGUITexture;
import binnie.craftgui.resource.minecraft.StandardTexture;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiCraftGUI
extends GuiContainer
implements IRendererMinecraft {
    Vector2f mousePos = new Vector2f(0.0f, 0.0f);
    Window window;
    ItemStack draggedItem;
    ITexture currentTexture;
    int currentColour = 0xFFFFFF;
    IWidget currentWidget;
    Map subRenderers = new HashMap();

    public void func_73876_c() {
        this.window.update();
    }

    public Minecraft getMinecraft() {
        return this.field_73882_e;
    }

    public GuiCraftGUI(Window window, float width, float height) {
        super((Container)window.getContainer());
        this.window = window;
        this.field_74194_b = (int)width;
        this.field_74195_c = (int)height;
        this.addSubRenderer(IRendererWidget.class, new RendererWidgetMinecraft(this));
    }

    protected void func_74185_a(float var1, int var2, int var3) {
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_73882_e.field_71439_g.field_71070_bA = this.field_74193_d;
        this.field_74198_m = (this.field_73880_f - this.field_74194_b) / 2;
        this.field_74197_n = (this.field_73881_g - this.field_74195_c) / 2;
        this.window.setSize(new Vector2f(this.field_74194_b, this.field_74195_c));
        this.window.setPosition(new Vector2f(this.field_74198_m, this.field_74197_n));
        this.window.initGui();
    }

    public ItemStack getDraggedItem() {
        return this.draggedItem;
    }

    public void func_73863_a(int mouseX, int mouseY, float par3) {
        this.window.setMousePosition(mouseX - (int)this.window.getPosition().x(), mouseY - (int)this.window.getPosition().y());
        this.func_73873_v_();
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.window.renderBackground();
        this.window.renderForeground();
        this.window.renderOverlay();
        RenderHelper.func_74520_c();
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        InventoryPlayer playerInventory = this.field_73882_e.field_71439_g.field_71071_by;
        this.draggedItem = playerInventory.func_70445_o();
        if (this.draggedItem != null) {
            this.renderItem(new Vector2f(mouseX - 8, mouseY - 8), this.draggedItem, 200);
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        MinecraftTooltip tooltip = new MinecraftTooltip();
        tooltip.setType(this.getTooltipType());
        this.window.getTooltip(tooltip);
        if (tooltip.exists() && this.draggedItem == null) {
            this.renderTooltip(new Vector2f(mouseX, mouseY), tooltip);
        }
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public void renderTooltip(IPosition mousePosition, MinecraftTooltip tooltip) {
        int i2;
        int mouseX = (int)mousePosition.x();
        int mouseY = (int)mousePosition.y();
        FontRenderer font = this.field_73886_k;
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int k = 0;
        ArrayList strings = new ArrayList();
        for (String string : tooltip.getList()) {
            strings.addAll(font.func_78271_c(string, tooltip.maxWidth));
        }
        for (String s : strings) {
            int l = font.func_78256_a(s);
            if (l <= k) continue;
            k = l;
        }
        int i1 = mouseX + 12;
        int j1 = mouseY - 12;
        int k1 = 8;
        if (strings.size() > 1) {
            k1 += 2 + (strings.size() - 1) * 10;
        }
        if (i1 + k > this.field_73880_f) {
            i1 -= 28 + k;
        }
        if (j1 + k1 + 6 > this.field_73881_g) {
            j1 = this.field_73881_g - k1 - 6;
        }
        this.field_73735_i = 300.0f;
        GuiCraftGUI.field_74196_a.field_77023_b = 300.0f;
        int l1 = -267386864;
        int j2 = i2 = 0x50000000 + MinecraftTooltip.getOutline(tooltip.getType());
        this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
        this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
        this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
        this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
        this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
        this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
        this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
        this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
        this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
        for (int k2 = 0; k2 < strings.size(); ++k2) {
            String s1 = (String)strings.get(k2);
            s1 = k2 == 0 ? MinecraftTooltip.getTitle(tooltip.getType()) + s1 : MinecraftTooltip.getBody(tooltip.getType()) + s1;
            font.func_78261_a(s1, i1, j1, -1);
            if (k2 == 0) {
                j1 += 2;
            }
            j1 += 10;
        }
        this.field_73735_i = 0.0f;
        GuiCraftGUI.field_74196_a.field_77023_b = 0.0f;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)32826);
    }

    protected void func_73864_a(int x, int y, int button) {
        IWidget origin = this.window;
        if (this.window.getMousedOverWidget() != null) {
            origin = this.window.getMousedOverWidget();
        }
        this.window.callEvent(new EventMouse.Down(origin, x, y, button));
    }

    public boolean isShiftDown() {
        return Keyboard.isKeyDown((int)this.field_73882_e.field_71474_y.field_74311_E.field_74512_d);
    }

    protected void func_73869_a(char c, int key) {
        if (key == 1 || key == this.field_73882_e.field_71474_y.field_74315_B.field_74512_d && this.window.getFocusedWidget() == null) {
            this.field_73882_e.field_71439_g.func_71053_j();
        }
        IWidget origin = this.window.getFocusedWidget() == null ? this.window : this.window.getFocusedWidget();
        this.window.callEvent(new EventKey.Down(origin, c, key));
    }

    protected void func_73879_b(int x, int y, int button) {
        IWidget origin;
        IWidget iWidget = origin = this.window.getMousedOverWidget() == null ? this.window : this.window.getMousedOverWidget();
        if (button == -1) {
            float dx = (float)Mouse.getEventDX() * (float)this.field_73880_f / (float)this.field_73882_e.field_71443_c;
            float dy = -((float)Mouse.getEventDY() * (float)this.field_73881_g / (float)this.field_73882_e.field_71440_d);
        } else {
            this.window.callEvent(new EventMouse.Up(origin, x, y, button));
        }
    }

    public void func_73867_d() {
        IWidget origin;
        super.func_73867_d();
        int dWheel = Mouse.getDWheel();
        IWidget iWidget = origin = this.window.getFocusedWidget() == null ? this.window : this.window.getFocusedWidget();
        if (dWheel != 0) {
            this.window.callEvent(new EventMouse.Wheel(this.window, dWheel));
        }
    }

    public void func_73874_b() {
        this.window.onClose();
    }

    private void renderTexturedRect(float x, float y, float u, float v, float w, float h) {
        this.func_73729_b((int)x, (int)y, (int)u, (int)v, (int)w, (int)h);
    }

    private void renderTexturedRect(IArea area, IPosition uv) {
        this.renderTexturedRect(area.pos().x(), area.pos().y(), uv.x(), uv.y(), area.size().x(), area.size().y());
    }

    @Override
    public void renderTexture(Object key, IPosition position) {
        ITexture texture = this.getTexture(key);
        if (texture == null) {
            return;
        }
        this.setTexture(texture);
        this.renderTexturedRect(position.x(), position.y(), texture.u(), texture.v(), texture.w(), texture.h());
    }

    @Override
    public void renderTexture(Object key, IArea area) {
        ITexture texture = this.getTexture(key);
        if (texture == null) {
            return;
        }
        if (texture instanceof ITexturePadded && ((float)texture.w() != area.size().x() || (float)texture.h() != area.size().y())) {
            this.renderTexturePadded((ITexturePadded)texture, area);
        } else {
            this.renderTexture((Object)texture, area.pos());
        }
    }

    @Override
    public void renderTextureTiled(Object key, IArea area) {
        ITexture texture = this.getTexture(key);
        this.renderTexturePadded(texture, area, new Area(0.0f, 0.0f, 0.0f, 0.0f));
    }

    private void renderTexturePadded(ITexturePadded texture, IArea area) {
        this.renderTexturePadded(texture, area, new Area(texture.l(), texture.r(), texture.t(), texture.b()));
    }

    private void renderTexturePadded(ITexture texture, IArea area, IArea padding) {
        int texturingHeight;
        int texturingWidth;
        this.setTexture(texture);
        int borderLeft = (int)padding.pos().x();
        int borderRight = (int)padding.pos().y();
        int borderTop = (int)padding.size().x();
        int borderBottom = (int)padding.size().y();
        int posX = (int)area.pos().x();
        int posY = (int)area.pos().y();
        int width = (int)area.size().x();
        int height = (int)area.size().y();
        int textWidth = texture.w();
        int textHeight = texture.h();
        int u = texture.u();
        int v = texture.v();
        IPosition origin = area.pos();
        this.func_73729_b(posX, posY, u, v, borderLeft, borderTop);
        this.func_73729_b(posX + width - borderRight, posY, u + textWidth - borderRight, v, borderRight, borderTop);
        this.func_73729_b(posX, posY + height - borderBottom, u, v + textHeight - borderBottom, borderLeft, borderBottom);
        this.func_73729_b(posX + width - borderRight, posY + height - borderBottom, u + textWidth - borderRight, v + textHeight - borderBottom, borderRight, borderBottom);
        for (int currentXPos = borderLeft; currentXPos < width - borderRight; currentXPos += texturingWidth) {
            int texturingHeight2;
            texturingWidth = textWidth - borderLeft - borderRight;
            int distanceXRemaining = width - borderRight - currentXPos;
            if (texturingWidth > distanceXRemaining) {
                texturingWidth = distanceXRemaining;
            }
            this.func_73729_b(posX + currentXPos, posY, u + borderLeft, v, texturingWidth, borderTop);
            this.func_73729_b(posX + currentXPos, posY + height - borderBottom, u + borderLeft, v + textHeight - borderBottom, texturingWidth, borderBottom);
            for (int currentYPos = borderTop; currentYPos < height - borderBottom; currentYPos += texturingHeight2) {
                texturingHeight2 = textHeight - borderTop - borderBottom;
                int distanceYRemaining = height - borderBottom - currentYPos;
                if (texturingHeight2 > distanceYRemaining) {
                    texturingHeight2 = distanceYRemaining;
                }
                this.func_73729_b(posX + currentXPos, posY + currentYPos, u + borderLeft, v + borderTop, texturingWidth, texturingHeight2);
            }
        }
        for (int currentYPos = borderTop; currentYPos < height - borderBottom; currentYPos += texturingHeight) {
            texturingHeight = textHeight - borderTop - borderBottom;
            int distanceYRemaining = height - borderBottom - currentYPos;
            if (texturingHeight > distanceYRemaining) {
                texturingHeight = distanceYRemaining;
            }
            this.func_73729_b(posX, posY + currentYPos, u, v + borderTop, borderLeft, texturingHeight);
            this.func_73729_b(posX + width - borderRight, posY + currentYPos, u + textWidth - borderRight, v + borderTop, borderRight, texturingHeight);
        }
    }

    @Override
    public void setTexture(ITexture texture) {
        if (!(texture instanceof StandardTexture)) {
            return;
        }
        if (texture != this.currentTexture && texture != null) {
            BinnieCore.proxy.bindTexture(((StandardTexture)texture).getTexture());
        }
        this.setColour(this.currentColour);
    }

    @Override
    public int getTextWidth(String text) {
        return this.field_73886_k.func_78256_a(text);
    }

    @Override
    public int getTextHeight() {
        return this.field_73886_k == null ? 0 : this.field_73886_k.field_78288_b;
    }

    @Override
    public void renderText(IPosition pos, String text, int colour) {
        this.renderText(new Area(pos, new Vector2f(500.0f, 500.0f)), TextJustification.TopLeft, text, colour);
    }

    @Override
    public void renderText(IArea area, TextJustification justification, String text, int colour) {
        IPosition pos = area.pos();
        List wrappedStrings = this.field_73886_k.func_78271_c(text, (int)area.size().x());
        float totalHeight = wrappedStrings.size() * this.getTextHeight();
        float posY = area.pos().y();
        if (area.size().y() > totalHeight) {
            posY += (area.size().y() - totalHeight) * justification.getYOffset();
        }
        for (String string : wrappedStrings) {
            float stringWidth = this.getTextWidth(string);
            float posX = area.size().x() - stringWidth;
            this.field_73886_k.func_78276_b(string, (int)(pos.x() + (posX *= justification.getXOffset())), (int)(pos.y() + posY), colour);
            posY += (float)this.getTextHeight();
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void renderSolidArea(IArea area, int colour) {
        GuiCraftGUI.func_73734_a((int)((int)area.pos().x()), (int)((int)area.pos().y()), (int)((int)(area.pos().x() + area.size().x())), (int)((int)(area.pos().y() + area.size().y())), (int)(0xFF000000 | colour));
        this.renderGradientRect(area, colour, colour);
    }

    @Override
    public void renderItem(IPosition pos, ItemStack item) {
        this.renderItem(pos, item, 100);
    }

    private void renderItem(IPosition pos, ItemStack item, int zLevel) {
        RenderHelper.func_74520_c();
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = zLevel;
        GuiCraftGUI.field_74196_a.field_77023_b = zLevel;
        FontRenderer font = item.func_77973_b().getFontRenderer(item);
        if (font == null) {
            font = this.field_73886_k;
        }
        field_74196_a.func_82406_b(font, this.field_73882_e.field_71446_o, item, (int)pos.x(), (int)pos.y());
        field_74196_a.func_94148_a(font, this.field_73882_e.field_71446_o, item, (int)pos.x(), (int)pos.y(), null);
        this.field_73735_i = 0.0f;
        GuiCraftGUI.field_74196_a.field_77023_b = 0.0f;
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-32.0f);
        RenderHelper.func_74518_a();
        GL11.glEnable((int)32826);
        GL11.glPopMatrix();
    }

    @Override
    public void renderBlockIcon(IPosition pos, Icon icon) {
        this.renderIcon(pos, icon, this.field_73882_e.field_71446_o.field_94154_l);
    }

    @Override
    public void renderItemIcon(IPosition pos, Icon icon) {
        this.renderIcon(pos, icon, this.field_73882_e.field_71446_o.field_94155_m);
    }

    private void renderIcon(IPosition pos, Icon icon, TextureMap map) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 0.0f;
        GuiCraftGUI.field_74196_a.field_77023_b = 0.0f;
        if (map == this.field_73882_e.field_71446_o.field_94155_m) {
            this.field_73882_e.field_71446_o.func_98187_b("/gui/items.png");
        } else {
            this.field_73882_e.field_71446_o.func_98187_b("/terrain.png");
        }
        field_74196_a.func_94149_a((int)pos.x(), (int)pos.y(), icon, 16, 16);
        this.field_73735_i = 0.0f;
        GuiCraftGUI.field_74196_a.field_77023_b = 0.0f;
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-32.0f);
    }

    @Override
    public void renderGradientRect(IArea area, int c1, int c2) {
        this.func_73733_a((int)area.pos().x(), (int)area.pos().y(), (int)(area.pos().x() + area.size().x()), (int)(area.pos().y() + area.size().y()), c1, c2);
    }

    @Override
    public void setColour(int hex) {
        this.currentColour = hex;
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        GL11.glColor3f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f));
    }

    @Override
    public void limitArea(IArea area) {
        int x = (int)area.pos().x();
        int y = (int)area.pos().y();
        int w = (int)area.size().x();
        int h = (int)area.size().y();
        y = this.field_73881_g - (y + h);
        float k = this.field_74194_b;
        float scaleX = (float)this.field_73880_f / (float)this.field_73882_e.field_71443_c;
        float scaleY = (float)this.field_73881_g / (float)this.field_73882_e.field_71440_d;
        GL11.glScissor((int)((int)((float)x / scaleX)), (int)((int)((float)y / scaleY)), (int)((int)((float)w / scaleX) + 2), (int)((int)((float)h / scaleY)));
    }

    @Override
    public float getTextHeight(String text, float width) {
        return this.field_73886_k.func_78271_c(text, (int)width).size() * this.field_73886_k.field_78288_b;
    }

    @Override
    public void renderSubTexture(ITexture texture, IArea area, Direction direction, float percentage) {
        float x = area.pos().x();
        float y = area.pos().y();
        float w = area.size().x();
        float h = area.size().y();
        float u = texture.u();
        float v = texture.v();
        switch (direction) {
            case Downwards: {
                h *= percentage;
                break;
            }
            case Left: {
                x += (1.0f - percentage) * w;
                u += (1.0f - percentage) * w;
                w *= percentage;
                break;
            }
            case Right: {
                w *= percentage;
                break;
            }
            case Upwards: {
                y += h - (float)((int)(percentage * h));
                v += (float)(texture.h() - (int)(percentage * (float)texture.h()));
                h *= percentage;
            }
        }
        this.renderTexturedRect(x, y, u, v, w, h);
    }

    private ITexture getTexture(Object key) {
        if (key instanceof ITexture) {
            return (ITexture)key;
        }
        return this.currentWidget.getTexture(key);
    }

    @Override
    public void setWidget(IWidget widget) {
        this.currentWidget = widget;
    }

    @Override
    public Object subRenderer(Class renderer) {
        if (this.subRenderers.containsKey(renderer)) {
            return this.subRenderers.get(renderer);
        }
        return this;
    }

    @Override
    public void renderWindow(Window window) {
        this.setColour(0xFFFFFF);
        this.renderTexture((Object)window.getBackground1(), Vector2f.ZERO);
        if (window.getBackground2() != null) {
            this.renderTexture((Object)window.getBackground2(), new Vector2f(256.0f, 0.0f));
        }
        this.setColour(window.getColour());
        this.renderTexture((Object)CraftGUITexture.Window, window.getArea());
    }

    @Override
    public void addSubRenderer(Class rendererClass, Object renderer) {
        this.subRenderers.put(rendererClass, renderer);
    }

    public Tooltip.ITooltipType getTooltipType() {
        if (Keyboard.isKeyDown((int)15)) {
            return Tooltip.Type.Help;
        }
        return Tooltip.Type.Standard;
    }
}

