/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft;

import binnie.core.machines.Machine;
import binnie.core.machines.power.IProcess;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.Direction;
import binnie.craftgui.minecraft.ControlProgressBase;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.resource.ITexture;
import java.util.ArrayList;
import java.util.List;

public class ControlProgress
extends ControlProgressBase
implements ITooltip {
    ITexture progressBlank;
    ITexture progressBar;
    protected Direction direction;
    public boolean isMachineProcess = true;
    public List helpStrings = new ArrayList();

    public ControlProgress(IWidget parent, int x, int y, ITexture progressBlank, ITexture progressBar, Direction dir) {
        super(parent, x, y, progressBlank == null ? 0.0f : (float)progressBlank.w(), progressBlank == null ? 0.0f : (float)progressBlank.h());
        this.progressBlank = progressBlank;
        this.progressBar = progressBar;
        this.progress = 0.0f;
        this.direction = dir;
        this.canMouseOver = true;
    }

    @Override
    public void onRenderBackground() {
        this.getRenderer().renderTexture((Object)this.progressBlank, this.getArea());
        this.getRenderer().renderSubTexture(this.progressBar, this.getArea(), this.direction, this.progress);
    }

    private IProcess getProcess() {
        return (IProcess)Machine.getInterface(IProcess.class, Window.get(this).getInventory());
    }

    @Override
    public void onUpdate() {
        IProcess process = this.getProcess();
        if (process != null && this.isMachineProcess) {
            this.setProgress(process.getProgress() / 100.0f);
        }
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        IProcess process = this.getProcess();
        if (tooltip.getType() == Tooltip.Type.Help && process != null) {
            if (this.isMachineProcess) {
                tooltip.add("Progress");
                if (this.progress == 0.0f) {
                    tooltip.add("Not in Progress");
                } else {
                    tooltip.add(process.getTooltip() + " (" + (int)process.getProgress() + "%)");
                }
                float eff = process.getEfficiency();
                if (eff == 0.0f) {
                    tooltip.add("Time Left: Infinite");
                } else {
                    tooltip.add("Time Left: " + this.convertTime((int)((1.0f - this.progress) * (float)process.getProcessLength() / eff)));
                }
                tooltip.add("Total Time: " + this.convertTime(process.getProcessLength()));
                tooltip.add("Energy Cost: " + process.getProcessEnergy() + " MJ");
            } else {
                tooltip.add(this.helpStrings);
            }
        }
    }

    private String convertTime(int time) {
        int seconds;
        int minutes = 0;
        for (seconds = (int)((float)time / 20.0f); seconds > 60; seconds -= 60) {
            ++minutes;
        }
        String ts = "";
        if (minutes > 0) {
            ts = ts + minutes + " minute" + (minutes == 1 ? "" : "s");
        }
        if (seconds > 0) {
            if (ts.length() > 0) {
                ts = ts + " ";
            }
            ts = ts + seconds + " second" + (seconds == 1 ? "" : "s");
        }
        return ts;
    }
}

