/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extrabees;

import binnie.core.IBinnieMod;
import binnie.craftgui.controls.ControlText;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.Direction;
import binnie.craftgui.core.geometry.TextJustification;
import binnie.craftgui.extrabees.ControlEnergyBarOld;
import binnie.craftgui.extrabees.ControlErrorStateOld;
import binnie.craftgui.extrabees.ControlExtraBeeProgress;
import binnie.craftgui.minecraft.ControlPlayerInventory;
import binnie.craftgui.minecraft.ControlSlot;
import binnie.craftgui.minecraft.ControlSlotArray;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.resource.ITexture;
import binnie.craftgui.resource.minecraft.StandardTexture;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.core.ExtraBeeTexture;
import binnie.extrabees.machines.tile.TileEntitySequencer;
import cpw.mods.fml.relauncher.Side;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class WindowSequencer
extends Window {
    EntityPlayer player;
    ControlPlayerInventory playerInventory;
    TileEntitySequencer machine;
    ControlSlot slotBee;
    ControlSlotArray slotReserve;
    ControlSlot slotTemplate;
    ControlSlot slotTemplateFinished;
    ControlExtraBeeProgress sequenceProgress;
    ControlExtraBeeProgress dnaProgress;
    ControlText speciesUID;
    static ITexture ProgressBase = new StandardTexture(64, 114, 98, 9, ExtraBeeTexture.GUIProgress.getTexture());
    static ITexture Progress = new StandardTexture(64, 123, 98, 9, ExtraBeeTexture.GUIProgress.getTexture());
    static ITexture ProgressBase2 = new StandardTexture(64, 42, 45, 72, ExtraBeeTexture.GUIProgress.getTexture());
    static ITexture Progress2 = new StandardTexture(109, 42, 45, 72, ExtraBeeTexture.GUIProgress.getTexture());

    public WindowSequencer(EntityPlayer player, IInventory inventory, Side side) {
        super(244.0f, 192.0f, player, inventory, side);
        this.player = player;
        this.machine = (TileEntitySequencer)inventory;
    }

    public static Window create(EntityPlayer player, IInventory inventory, Side side) {
        if (player == null || inventory == null) {
            return null;
        }
        return new WindowSequencer(player, inventory, side);
    }

    @Override
    public void initialize() {
        this.setTitle("Sequencer");
        this.playerInventory = new ControlPlayerInventory(this);
        this.speciesUID = new ControlText(this, new Area(125.0f, 67.0f, 100.0f, 20.0f), "", TextJustification.MiddleCenter);
        this.speciesUID.setColour(0xA0A0A0);
        this.sequenceProgress = new ControlExtraBeeProgress(this, 79, 53, ProgressBase, Progress, Direction.Right);
        this.dnaProgress = new ControlExtraBeeProgress(this, 186, 24, ProgressBase2, Progress2, Direction.Upwards);
        this.dnaProgress.isMachineProcess = false;
        this.dnaProgress.helpStrings.add("Template Progress");
        this.slotBee = new ControlSlot(this, 55, 50);
        this.slotReserve = new ControlSlotArray((IWidget)this, 11, 32, 2, 3);
        this.slotTemplate = new ControlSlot(this, 199, 78);
        this.slotTemplateFinished = new ControlSlot(this, 199, 24);
        this.slotBee.create(this.machine, 2);
        this.slotReserve.create(this.machine, TileEntitySequencer.SlotReserves[0]);
        this.slotTemplate.create(this.machine, 3);
        this.slotTemplateFinished.create(this.machine, 4);
        ControlEnergyBarOld energyBar = new ControlEnergyBarOld((IWidget)this, 12, 116, 14, 60);
        new ControlErrorStateOld(this, 70.0f, 80.0f);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.dnaProgress.setProgress(this.machine.DNAProgress / 100.0f);
        String uid = this.machine.SpeciesUID;
        if (AlleleManager.alleleRegistry.getAllele(uid) == null) {
            this.speciesUID.setValue("None");
        } else {
            this.speciesUID.setValue(((IAlleleSpecies)AlleleManager.alleleRegistry.getAllele(uid)).getName());
        }
    }

    @Override
    public IBinnieMod getMod() {
        return ExtraBees.instance;
    }

    @Override
    public String getName() {
        return "Sequencer";
    }
}

