/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.core.renderer;

import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPosition;
import binnie.craftgui.core.geometry.TextJustification;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.core.renderer.IFont;
import binnie.craftgui.core.renderer.ITexture;
import binnie.craftgui.core.renderer.TextureType;

public class Renderer {
    public void renderText(IPosition position, IFont font, String text) {
        font.renderText(position, text);
    }

    public void renderText(IArea area, TextJustification justification, IFont font, String text) {
        String[] strings = area.size().x() > 0.0f ? font.convertToMultiLine(text, area.size().x()) : new String[]{text};
        if (strings.length == 0) {
            return;
        }
        float textHeight = 0.0f;
        for (String string : strings) {
            textHeight += font.getHeight(string);
        }
        float x = area.pos().x();
        float y = area.pos().y();
        if (area.size().y() > 0.0f) {
            y += (area.size().y() - textHeight) * justification.getYOffset();
        }
        for (String string : strings) {
            float textWidth = font.getWidth(string);
            if (area.size().x() > 0.0f) {
                x += (area.size().x() - textWidth) * justification.getXOffset();
            }
            this.renderText(new Vector2f(x, y), font, string);
            y += font.getHeight(string);
        }
    }

    public void renderTexture(Object key, IPosition position) {
        ITexture texture = this.getTexture(key);
        if (texture != null) {
            texture.renderTexture(position);
        }
    }

    private ITexture getTexture(Object key) {
        if (key instanceof ITexture) {
            return (ITexture)key;
        }
        return null;
    }

    public void renderTexture(Object key, IArea area) {
        this.renderTexture(key, area, TextureType.Stretched);
    }

    public void renderTexture(Object key, IArea area, TextureType type) {
        ITexture texture = this.getTexture(key);
        if (texture != null) {
            texture.renderTexture(area, type);
        }
    }
}

