/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.core;

import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Widget;
import binnie.craftgui.events.Event;
import binnie.craftgui.events.core.EventHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class WidgetData {
    Class widgetClass;
    Map listeners = new HashMap();

    public WidgetData(Class widgetClass) {
        this.widgetClass = widgetClass;
        Class currentClass = widgetClass;
        while (!currentClass.equals(Widget.class)) {
            try {
                for (Method method : currentClass.getMethods()) {
                    if (!method.isAnnotationPresent(EventHandler.class)) continue;
                    Class<?> eventClass = method.getParameterTypes()[0];
                    this.listeners.put(eventClass, new EventListener(this, method, eventClass));
                }
            }
            catch (Exception e) {
                System.err.println("Error when registering widget class " + currentClass.getName());
                e.printStackTrace(System.err);
            }
            currentClass = currentClass.getSuperclass();
        }
    }

    public void handleEvent(IWidget widget, Event event) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.listeners.containsKey(event.getClass()) && ((EventListener)this.listeners.get(event.getClass())).handlesEvent(widget, event)) {
            ((EventListener)this.listeners.get(event.getClass())).invoke(widget, event);
        }
    }

    static class EventListener {
        WidgetData widgetdata;
        Method method;
        EventHandler eventHandler;
        Class eventClass;

        private EventListener(WidgetData widgetdata, Method method, Class eventClass) {
            this.widgetdata = widgetdata;
            this.method = method;
            this.eventClass = eventClass;
            this.eventHandler = method.getAnnotation(EventHandler.class);
        }

        public boolean handlesEvent(IWidget widget, Event event) {
            return this.eventHandler.origin().handlesEvent(widget, event);
        }

        public void invoke(IWidget widget, Event event) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.method.invoke((Object)widget, event);
        }
    }
}

