/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.controls.scroll;

import binnie.craftgui.controls.core.Control;
import binnie.craftgui.controls.scroll.ControlScroll;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.events.core.EventHandler;

public class ControlScrollBar
extends Control {
    ControlScroll parent;
    float maxHeight = 0.0f;

    @EventHandler(origin=EventHandler.Origin.Self)
    public void onMouseDrag(EventMouse.Drag event) {
        this.parent.getScrollableWidget().movePercentage(event.getDy() / this.maxHeight);
    }

    public ControlScrollBar(ControlScroll parent) {
        super(parent, 0.0f, parent.getSize().x(), parent.getSize().x(), parent.getSize().y() - parent.getSize().x() * 2.0f);
        this.maxHeight = parent.getSize().y() - parent.getSize().x() * 2.0f;
        this.parent = parent;
        this.canMouseOver = true;
    }

    @Override
    public void onUpdate() {
        float yOffset = this.maxHeight * this.parent.getScrollableWidget().getPercentageIndex();
        this.setOffset(new Vector2f(0.0f, yOffset));
    }

    @Override
    public boolean isEnabled() {
        return this.parent.getScrollableWidget().getPercentageShown() < 1.0f;
    }

    public float getBarHeight() {
        return this.maxHeight * this.parent.getScrollableWidget().getPercentageShown();
    }
}

