/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.proxy;

import binnie.core.genetics.BreedingMessageHandler;
import binnie.core.network.IPacketProvider;
import binnie.core.network.packet.BinniePacket;
import binnie.core.proxy.BinnieProxy;
import binnie.core.proxy.IBinnieProxy;
import binnie.core.resource.BinnieResource;
import binnie.core.resource.ResourceManager;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public class BinnieProxyClient
extends BinnieProxy
implements IBinnieProxy {
    List liquids = new ArrayList();

    @Override
    public void bindTexture(BinnieResource texture) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraftInstance().field_71446_o.func_98187_b(texture.getFullPath());
    }

    @Override
    public boolean isSimulating(World world) {
        return !world.field_72995_K;
    }

    @Override
    public void registerCustomItemRenderer(int itemID, IItemRenderer itemRenderer) {
        MinecraftForgeClient.registerItemRenderer((int)itemID, (IItemRenderer)itemRenderer);
    }

    @Override
    public World getWorld() {
        return this.getMinecraftInstance().field_71441_e;
    }

    @Override
    public Minecraft getMinecraftInstance() {
        return FMLClientHandler.instance().getClient();
    }

    @Override
    public void sendToServer(IPacketProvider mod, BinniePacket packet) {
        packet.setChannel(mod.getChannel());
        this.getMinecraftInstance().func_71391_r().func_72552_c(packet.getPacket());
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public File getDirectory() {
        return Minecraft.func_71380_b();
    }

    @Override
    public void registerTileEntity(Class tile, String id, Object renderer) {
        if (renderer != null && renderer instanceof TileEntitySpecialRenderer) {
            ClientRegistry.registerTileEntity((Class)tile, (String)id, (TileEntitySpecialRenderer)((TileEntitySpecialRenderer)renderer));
        } else {
            GameRegistry.registerTileEntity((Class)tile, (String)id);
        }
    }

    @Override
    public void registerBlockRenderer(Object renderer) {
        if (renderer != null && renderer instanceof ISimpleBlockRenderingHandler) {
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)((ISimpleBlockRenderingHandler)renderer));
        }
    }

    @Override
    public void createPipe(Item pipe) {
    }

    @Override
    public Object createObject(String renderer) {
        Object object = null;
        try {
            Class<?> rendererClass = Class.forName(renderer);
            if (rendererClass != null) {
                object = rendererClass.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    @Override
    public Icon getIcon(IconRegister register, String mod, String name) {
        return register.func_94245_a(mod + ":" + name);
    }

    @Override
    public void preInit() {
        super.preInit();
        new BreedingMessageHandler(this.getMinecraftInstance());
        TickRegistry.registerTickHandler((ITickHandler)BreedingMessageHandler.instance, (Side)Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)BreedingMessageHandler.instance);
    }

    @Override
    public LiquidStack registerLiquid(String name, int id, int meta) {
        LiquidStack liquid = super.registerLiquid(name, id, meta);
        this.liquids.add(name);
        return liquid;
    }

    @Override
    public void handleTextureRefresh(IconRegister register, int type) {
        ResourceManager.registerIcons(register, type);
    }

    @Override
    public void handlePostTextureRefresh(IconRegister register, int type) {
        if (type == 0) {
            return;
        }
        for (String liquidName : this.liquids) {
            Item item;
            LiquidStack liquid = LiquidDictionary.getCanonicalLiquid((String)liquidName);
            if (liquid == null || (item = liquid.asItemStack().func_77973_b()) == null) continue;
            Icon icon = liquid.asItemStack().func_77973_b().func_77617_a(liquid.itemMeta);
            if (icon == null) {
                throw new RuntimeException("[Binnie] Liquid " + liquid.asItemStack().func_82833_r() + " has invalid icon");
            }
            liquid.setRenderingIcon(icon);
            liquid.setTextureSheet("/gui/items.png");
        }
    }
}

