/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.liquid.LiquidManager;
import binnie.core.machines.inventory.Validator;
import net.minecraftforge.liquids.LiquidStack;

public abstract class TankValidator
extends Validator {

    public static class Basic
    extends TankValidator {
        LiquidStack liquid;

        public Basic(int id, int meta) {
            this.liquid = new LiquidStack(id, 1, meta);
        }

        public Basic(String id) {
            LiquidStack liquid = LiquidManager.getLiquidStack(id, 1);
            if (liquid == null) {
                throw new RuntimeException("Tank Validator is using a non existant liquid " + id);
            }
            this.liquid = liquid;
        }

        public boolean isValid(LiquidStack stack) {
            return this.liquid.isLiquidEqual(stack);
        }

        @Override
        public String getTooltip() {
            return this.liquid.asItemStack().func_82833_r();
        }
    }
}

