/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.inventory.IInventoryMachine;
import binnie.core.machines.transfer.TransferRequest;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class ComponentInventoryTransfer
extends MachineComponent {
    List transfers = new ArrayList();

    public ComponentInventoryTransfer(IMachine machine) {
        super(machine);
    }

    public void addRestock(int[] buffer, int destination, int limit) {
        this.transfers.add(new Restock(buffer, destination, limit));
    }

    public void addRestock(int[] buffer, int destination) {
        this.transfers.add(new Restock(buffer, destination));
    }

    public void addStorage(int source, int[] destination) {
        this.transfers.add(new Storage(source, destination));
    }

    public void performTransfer(int source, int[] destination) {
        new Storage(source, destination).doTransfer((IInventory)this.getMachine().getInterface(IInventoryMachine.class));
    }

    @Override
    public void onUpdate() {
        for (Transfer transfer : this.transfers) {
            transfer.doTransfer((IInventory)this.getMachine().getInterface(IInventoryMachine.class));
        }
    }

    private class Storage
    implements Transfer {
        int source;
        int[] destination;

        private Storage(int source, int[] destination) {
            this.source = source;
            this.destination = destination;
        }

        @Override
        public void doTransfer(IInventory inv) {
            if (inv.func_70301_a(this.source) != null) {
                inv.func_70299_a(this.source, new TransferRequest(inv.func_70301_a(this.source), inv).setTargetSlots(this.destination).ignoreValidation().transfer(true));
            }
        }
    }

    private class Restock
    implements Transfer {
        int[] buffer;
        int destination;
        int limit;

        private Restock(int[] buffer, int destination, int limit) {
            this.buffer = buffer;
            this.destination = destination;
            this.limit = limit;
        }

        private Restock(int[] buffer, int destination) {
            this(buffer, destination, 64);
        }

        @Override
        public void doTransfer(IInventory inv) {
            if (inv.func_70301_a(this.destination) == null) {
                for (int i : this.buffer) {
                    ItemStack newStack;
                    if (inv.func_70301_a(i) == null || (newStack = inv.func_70298_a(i, this.limit)) == null) continue;
                    inv.func_70299_a(this.destination, newStack);
                    return;
                }
            }
        }
    }

    private static interface Transfer {
        public void doTransfer(IInventory var1);
    }
}

