/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.machines.Machine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.inventory.IChargedSlots;
import binnie.core.machines.network.INetwork;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;

public class ComponentChargedSlots
extends MachineComponent
implements INetwork.GUI,
IChargedSlots {
    Map charges = new HashMap();
    Map gui = new HashMap();

    public ComponentChargedSlots(Machine machine) {
        super(machine);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
    }

    public void addCharge(int slot) {
        this.charges.put(slot, Float.valueOf(0.0f));
        this.gui.put(slot, this.getUniqueProgressBarID());
    }

    @Override
    public void addGUINetworkData(Map data) {
        Iterator i$ = this.charges.keySet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            data.put(this.gui.get(i), (int)(((Float)this.charges.get(i)).floatValue() * 100.0f));
        }
    }

    @Override
    public void recieveGUINetworkData(int id, int data) {
        Iterator i$ = this.charges.keySet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            if (id != (Integer)this.gui.get(i)) continue;
            this.charges.put(i, Float.valueOf((float)data / 100.0f));
        }
    }

    @Override
    public float getCharge(int slot) {
        return this.charges.containsKey(slot) ? ((Float)this.charges.get(slot)).floatValue() : 0.0f;
    }

    @Override
    public void setCharge(int slot, float charge) {
        if (charge > 1.0f) {
            charge = 1.0f;
        }
        if (charge < 0.0f) {
            charge = 0.0f;
        }
        if (this.charges.containsKey(slot)) {
            this.charges.put(slot, Float.valueOf(charge));
        }
    }

    @Override
    public void onUpdate() {
        Iterator i$ = this.charges.keySet().iterator();
        while (i$.hasNext()) {
            int slot = (Integer)i$.next();
            if (!(this.getCharge(slot) <= 0.0f) || this.getUtil().decreaseStack(slot, 1) == null) continue;
            this.setCharge(slot, 1.0f);
        }
    }

    @Override
    public void alterCharge(int slot, float charge) {
        this.setCharge(slot, this.getCharge(slot) + charge);
    }
}

