/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.liquid;

import binnie.core.liquid.ILiquidType;
import binnie.core.liquid.LiquidContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class ItemLiquidContainer
extends Item {
    ILiquidType[] liquids;

    public ItemLiquidContainer(int i, ILiquidType[] liquids) {
        super(i);
        this.liquids = liquids;
        this.field_77777_bU = 64;
        this.func_77627_a(true);
        this.func_77655_b("liquidContainer");
        this.func_77637_a(CreativeTabs.field_78035_l);
        for (ILiquidType liquid : liquids) {
            liquid.setContainerItem(this);
        }
    }

    private ILiquidType getLiquid(int meta) {
        return meta >= this.liquids.length ? this.liquids[0] : this.liquids[meta];
    }

    public void func_94581_a(IconRegister register) {
        for (LiquidContainer container : LiquidContainer.values()) {
            container.updateIcons(register);
        }
    }

    public String func_77628_j(ItemStack itemstack) {
        if (itemstack == null) {
            return "???";
        }
        int meta = itemstack.func_77960_j();
        int container = meta / 16;
        int liquid = meta % 16;
        return this.getLiquid(liquid).getName() + " " + LiquidContainer.getContainer(container).getName();
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (LiquidContainer container : LiquidContainer.values()) {
            for (ILiquidType liquid : this.liquids) {
                itemList.add(new ItemStack((Item)this, 1, liquid.ordinal() + container.ordinal() * 16));
            }
        }
    }

    public Icon func_77618_c(int i, int j) {
        LiquidContainer container = LiquidContainer.getContainer(i / 16);
        if (j > 0) {
            return container.bottle;
        }
        return container.contents;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack item, int pass) {
        ILiquidType liquid = this.getLiquid(item.func_77960_j() % 16);
        if (pass == 0) {
            return liquid.getColour();
        }
        return super.func_82790_a(item, pass);
    }

    public boolean func_77623_v() {
        return true;
    }
}

