/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.VirtualBeeHousing;
import binnie.core.resource.ResourceManager;
import binnie.extrabees.ExtraBees;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import net.minecraft.entity.player.EntityPlayer;

public class BeeBreedingSystem
extends BreedingSystem {
    public BeeBreedingSystem() {
        this.iconUndiscovered = ResourceManager.getItemIcon(ExtraBees.instance, "icon/undiscoveredBee");
        this.iconDiscovered = ResourceManager.getItemIcon(ExtraBees.instance, "icon/discoveredBee");
    }

    @Override
    public float getChance(IMutation mutation, EntityPlayer player, IAllele species1, IAllele species2) {
        return ((IBeeMutation)mutation).getChance((IBeeHousing)new VirtualBeeHousing(player), species1, species2, this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate(species1.getUID())), this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate(species2.getUID())));
    }

    @Override
    public String getEpitome(float discoveredPercentage) {
        if (discoveredPercentage == 1.0f) {
            return "Sengir's Chosen";
        }
        if (discoveredPercentage < 0.1f) {
            return "Bee Swatter";
        }
        if (discoveredPercentage < 0.3f) {
            return "Amateur Beekeeper";
        }
        if (discoveredPercentage < 0.5f) {
            return "Apiarist-In-Training";
        }
        if (discoveredPercentage < 0.7f) {
            return "Professional Beekeeper";
        }
        if (discoveredPercentage < 0.9f) {
            return "Master Apiarist";
        }
        if (discoveredPercentage < 1.0f) {
            return "God amoungst Apiarists";
        }
        return "";
    }

    @Override
    public String getDescriptor() {
        return "Apiarist";
    }

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        return AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
    }

    @Override
    public String getChromosomeName(int i) {
        EnumBeeChromosome chromo = (EnumBeeChromosome)this.getChromosome(i);
        switch (chromo) {
            case CAVE_DWELLING: {
                return "Cave Dwelling";
            }
            case EFFECT: {
                return "Effect";
            }
            case FERTILITY: {
                return "Fertility";
            }
            case FLOWERING: {
                return "Pollination";
            }
            case FLOWER_PROVIDER: {
                return "Flowers";
            }
            case HUMIDITY: {
                return "Humidity";
            }
            case HUMIDITY_TOLERANCE: {
                return "Humidity Tolerance";
            }
            case LIFESPAN: {
                return "Lifespan";
            }
            case NOCTURNAL: {
                return "Nocturnal";
            }
            case SPECIES: {
                return "Species";
            }
            case SPEED: {
                return "Production";
            }
            case TEMPERATURE_TOLERANCE: {
                return "Temperature Tolerance";
            }
            case TERRITORY: {
                return "Territory";
            }
            case TOLERANT_FLYER: {
                return "Rain Tolerance";
            }
        }
        return "";
    }

    @Override
    public int getColour() {
        return 16767232;
    }

    @Override
    public Class getTrackerClass() {
        return IApiaristTracker.class;
    }
}

