/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.config;

import binnie.core.IBinnieMod;
import binnie.core.config.BinnieConfiguration;
import binnie.core.config.BinnieItemData;
import binnie.core.config.ConfigFile;
import binnie.core.config.ConfigProperty;
import binnie.core.config.PropertyBase;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ConfigurationManager {
    static Map configurations = new LinkedHashMap();
    public static Map itemIDs = new HashMap();

    public static void init() {
    }

    public static void registerConfiguration(Class cls, IBinnieMod mod) {
        if (cls.isAnnotationPresent(ConfigFile.class)) {
            ConfigurationManager.loadConfiguration(cls, mod);
        }
    }

    public static void loadConfiguration(Class cls, IBinnieMod mod) {
        try {
            String filename = cls.getAnnotation(ConfigFile.class).filename();
            BinnieConfiguration config = new BinnieConfiguration(filename, mod);
            config.load();
            for (Field field : cls.getFields()) {
                if (!field.isAnnotationPresent(ConfigProperty.class)) continue;
                ConfigProperty propertyAnnot = field.getAnnotation(ConfigProperty.class);
                for (Annotation annotation : field.getAnnotations()) {
                    if (!annotation.annotationType().isAnnotationPresent(ConfigProperty.Type.class)) continue;
                    Class propertyClass = annotation.annotationType().getAnnotation(ConfigProperty.Type.class).propertyClass();
                    PropertyBase property = (PropertyBase)propertyClass.getConstructor(Field.class, BinnieConfiguration.class, ConfigProperty.class, annotation.annotationType()).newInstance(new Object[]{field, config, propertyAnnot, annotation.annotationType().cast(annotation)});
                }
            }
            config.save();
            configurations.put(cls, config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addItemID(Integer configValue, String configKey, BinnieConfiguration configFile) {
        if (!itemIDs.containsKey(configFile.mod)) {
            itemIDs.put(configFile.mod, new ArrayList());
        }
        ((List)itemIDs.get(configFile.mod)).add(new BinnieItemData(configValue + 256, configFile, configKey));
    }
}

