/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.core.PluginInfo;
import forestry.api.food.BeverageManager;
import forestry.api.food.IBeverageEffect;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.interfaces.IOreDictionaryHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.items.ItemForestryFood;
import forestry.core.proxy.Proxies;
import forestry.core.utils.LiquidHelper;
import forestry.food.BeverageEffect;
import forestry.food.GuiHandlerFood;
import forestry.food.items.ItemAmbrosia;
import forestry.food.items.ItemBeverage;
import forestry.food.items.ItemInfuser;
import forestry.plugins.NativePlugin;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;

@PluginInfo(pluginID="Food", name="Food", author="SirSengir", url="http://forestry.sengir.net/", description="Adds food.")
public class PluginFood
extends NativePlugin {
    @Override
    public boolean isAvailable() {
        return !Config.disableFood;
    }

    @Override
    public void preInit() {
        super.preInit();
        BeverageManager.infuserManager = new ItemInfuser.MixtureManager();
        BeverageManager.ingredientManager = new ItemInfuser.IngredientManager();
    }

    @Override
    public void postInit() {
        super.postInit();
        ItemStack meadBottle = new ItemStack(ForestryItem.beverage, 1, 0);
        ((ItemBeverage)ForestryItem.beverage).beverages[0].saveEffects(meadBottle, new IBeverageEffect[]{BeverageEffect.weakAlcoholic});
        LiquidHelper.getOrCreateLiquid("mead", new LiquidStack(ForestryItem.liquidMead, 1000));
        LiquidHelper.injectLiquidContainer("mead", 1000, meadBottle, new ItemStack(Item.field_77729_bt));
        ItemInfuser.initialize();
    }

    @Override
    protected void registerItems() {
        ForestryItem.honeyedSlice = new ItemForestryFood(Config.getOrCreateItemIdProperty("honeyedSlice", 13035), 8, 0.6f).func_77655_b("honeyedSlice");
        ForestryItem.beverage = new ItemBeverage(Config.getOrCreateItemIdProperty("shortMead", 13036), new ItemBeverage.BeverageInfo[]{new ItemBeverage.BeverageInfo("meadShort", "glass", 15505945, 0xFFFFFF, 1, 0.2f, true), new ItemBeverage.BeverageInfo("meadCurative", "glass", 12975871, 0xFFFFFF, 1, 0.2f, true)}).func_77655_b("shortMead");
        ForestryItem.ambrosia = new ItemAmbrosia(Config.getOrCreateItemIdProperty("ambrosia", 13037)).setIsDrink().func_77655_b("ambrosia");
        ForestryItem.honeyPot = new ItemForestryFood(Config.getOrCreateItemIdProperty("honeyPot", 13056), 2, 0.2f).setIsDrink().func_77655_b("honeyPot");
        ForestryItem.infuser = new ItemInfuser(Config.getOrCreateItemIdProperty("infuser", 13108)).func_77655_b("infuser");
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerRecipes() {
        Proxies.common.addRecipe(new ItemStack(ForestryItem.infuser), new Object[]{"X", "#", "X", Character.valueOf('#'), Item.field_77703_o, Character.valueOf('X'), "ingotBronze"});
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerFood();
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return null;
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }
}

