/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.api.mail.TradeStationInfo;
import forestry.core.config.SessionVars;
import forestry.core.gui.GuiForestry;
import forestry.core.utils.StringUtil;
import forestry.mail.EnumAddressee;
import forestry.mail.gui.ContainerCatalogue;
import java.util.Locale;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiCatalogue
extends GuiForestry {
    GuiButton buttonTrade;
    GuiButton buttonClose;
    GuiButton buttonFilter;
    GuiButton buttonCopy;
    ContainerCatalogue container;

    public GuiCatalogue(EntityPlayer player) {
        super("/gui/book.png", new ContainerCatalogue(player));
        this.xSize = 192;
        this.ySize = 192;
        this.container = (ContainerCatalogue)this.inventorySlots;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_73887_h.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_73887_h.add(new GuiButton(2, this.field_73880_f / 2 + 44, this.guiTop + 150, 12, 20, ">"));
        this.field_73887_h.add(new GuiButton(3, this.field_73880_f / 2 - 58, this.guiTop + 150, 12, 20, "<"));
        this.buttonFilter = new GuiButton(4, this.field_73880_f / 2 - 44, this.guiTop + 150, 42, 20, StringUtil.localize("gui.mail.filter.all"));
        this.field_73887_h.add(this.buttonFilter);
        this.buttonCopy = new GuiButton(5, this.field_73880_f / 2, this.guiTop + 150, 42, 20, StringUtil.localize("gui.mail.address.copy"));
        this.field_73887_h.add(this.buttonCopy);
    }

    @Override
    public void func_73874_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_73874_b();
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3) {
        this.drawBackground();
        this.field_73886_k.func_78276_b(String.format("%s / %s", this.container.getCurrentPos(), this.container.getMaxCount()), this.guiLeft + this.xSize - 72, this.guiTop + 12, this.fontColor.get("gui.book"));
        if (this.container.getTradeInfo() != null) {
            this.drawTradePreview(this.guiLeft + 38, this.guiTop + 30);
        } else {
            this.drawNoTrade(this.guiLeft + 38, this.guiTop + 30);
        }
        this.buttonFilter.field_73744_e = StringUtil.localize("gui.mail.filter." + this.container.getFilterIdent());
        this.buttonCopy.field_73742_g = this.container.getTradeInfo() != null && this.container.getTradeInfo().state.isOk();
    }

    private void drawNoTrade(int x, int y) {
        this.field_73886_k.func_78279_b(StringUtil.localize("gui.mail.notrades"), x, y + 18, 119, this.fontColor.get("gui.book"));
    }

    private void drawTradePreview(int x, int y) {
        this.field_73886_k.func_78276_b("\u00a7l\u00a7n" + this.container.getTradeInfo().moniker, x, y, this.fontColor.get("gui.book"));
        TradeStationInfo info = this.container.getTradeInfo();
        this.field_73886_k.func_78276_b(String.format(StringUtil.localize("gui.mail.willtrade"), info.owner), x, y + 18, this.fontColor.get("gui.book"));
        itemRenderer.func_82406_b(this.field_73886_k, this.field_73882_e.field_71446_o, info.tradegood, x, y + 28);
        itemRenderer.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, info.tradegood, x, y + 28);
        GL11.glDisable((int)2896);
        this.field_73886_k.func_78276_b(StringUtil.localize("gui.mail.tradefor"), x, y + 46, this.fontColor.get("gui.book"));
        GL11.glEnable((int)2896);
        for (int i = 0; i < this.container.getTradeInfo().required.length; ++i) {
            GL11.glDisable((int)2896);
            itemRenderer.func_82406_b(this.field_73886_k, this.field_73882_e.field_71446_o, info.required[i], x + i * 18, y + 56);
            itemRenderer.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, info.required[i], x + i * 18, y + 56);
            GL11.glEnable((int)2896);
        }
        GL11.glDisable((int)2896);
        if (info.state.isOk()) {
            this.field_73886_k.func_78279_b("\u00a72" + StringUtil.localize("chat.mail." + info.state.getIdentifier()), x, y + 82, 119, this.fontColor.get("gui.book"));
        } else {
            this.field_73886_k.func_78279_b("\u00a74" + StringUtil.localize("chat.mail." + info.state.getIdentifier()), x, y + 82, 119, this.fontColor.get("gui.book"));
        }
        GL11.glEnable((int)2896);
    }

    protected void func_73875_a(GuiButton button) {
        switch (button.field_73741_f) {
            case 0: {
                this.field_73882_e.func_71373_a((GuiScreen)null);
                break;
            }
            case 2: {
                this.container.advanceIteration();
                break;
            }
            case 3: {
                this.container.regressIteration();
                break;
            }
            case 4: {
                this.container.cycleFilter();
                break;
            }
            case 5: {
                TradeStationInfo info = this.container.getTradeInfo();
                if (info != null) {
                    SessionVars.setStringVar("mail.letter.recipient", info.moniker);
                    SessionVars.setStringVar("mail.letter.addressee", EnumAddressee.TRADER.toString().toLowerCase(Locale.ENGLISH));
                }
                this.field_73882_e.func_71373_a((GuiScreen)null);
            }
        }
    }
}

