/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.farming.Farmables;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.Vect;
import forestry.farming.logic.FarmLogic;
import java.util.Collection;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class FarmLogicSucculent
extends FarmLogic {
    IFarmable[] germlings = ((Collection)Farmables.farmables.get("farmSucculentes")).toArray(new IFarmable[0]);

    public FarmLogicSucculent(IFarmHousing housing) {
        super(housing);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        return Item.field_77756_aW.func_77617_a(2);
    }

    @Override
    public String getName() {
        if (this.isManual) {
            return "Manual Succulent Farm";
        }
        return "Managed Succulent Farm";
    }

    @Override
    public int getFertilizerConsumption() {
        return 10;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return 1;
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        if (this.isManual) {
            return false;
        }
        return itemstack.field_77993_c == Block.field_71939_E.field_71990_ca;
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        if (this.isManual) {
            return false;
        }
        return itemstack.field_77993_c == Block.field_72038_aV.field_71990_ca;
    }

    @Override
    public Collection collect() {
        return null;
    }

    @Override
    public boolean cultivate(int x, int y, int z, ForgeDirection direction, int extent) {
        return false;
    }

    @Override
    public Collection harvest(int x, int y, int z, ForgeDirection direction, int extent) {
        this.world = this.housing.getWorld();
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, y + 1, z, direction, i);
            for (IFarmable seed : this.germlings) {
                ICrop crop = seed.getCropAt(this.world, position.x, position.y, position.z);
                if (crop == null) continue;
                crops.push(crop);
            }
        }
        return crops;
    }
}

