/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.core.utils.Vect;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class Crop
implements ICrop {
    protected World world;
    protected Vect position;

    public Crop(World world, Vect position) {
        this.world = world;
        this.position = position;
    }

    protected final void setBlock(Vect position, int id, int meta) {
        this.world.func_72832_d(position.x, position.y, position.z, id, meta, 2);
    }

    protected final void clearBlock(Vect position) {
        this.world.func_72832_d(position.x, position.y, position.z, 0, 0, 2);
        if (this.world.func_72796_p(position.x, position.y, position.z) != null) {
            this.world.func_72837_a(position.x, position.y, position.z, null);
        }
    }

    protected final int getBlockId(Vect position) {
        return this.world.func_72798_a(position.x, position.y, position.z);
    }

    protected final int getBlockMeta(Vect position) {
        return this.world.func_72805_g(position.x, position.y, position.z);
    }

    protected final ItemStack getAsItemStack(Vect position) {
        return new ItemStack(this.getBlockId(position), 1, this.getBlockMeta(position));
    }

    protected abstract boolean isCrop(Vect var1);

    protected abstract Collection harvestBlock(Vect var1);

    @Override
    public Collection harvest() {
        if (!this.isCrop(this.position)) {
            return null;
        }
        return this.harvestBlock(this.position);
    }
}

