/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.triggers;

import buildcraft.api.core.IIconProvider;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;

public abstract class Trigger
implements ITrigger,
IIconProvider {
    private int id;
    private String uid;
    private String unlocalized;
    @SideOnly(value=Side.CLIENT)
    private Icon icon;

    public Trigger(int id, String uid) {
        this.id = id;
        this.uid = uid;
        this.unlocalized = "trigger." + uid;
        ActionManager.triggers[id] = this;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize(this.unlocalized);
    }

    @Override
    public boolean hasParameter() {
        return false;
    }

    @Override
    public ITriggerParameter createParameter() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(int iconIndex) {
        return this.icon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister iconRegister) {
        this.icon = TextureManager.getInstance().registerItemTex("triggers/" + this.uid);
    }

    @Override
    public int getIconIndex() {
        return 0;
    }
}

