/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.proxy;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import forestry.core.TickHandlerCoreServer;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketFXSignal;
import forestry.core.proxy.Proxies;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.texturepacks.ITexturePack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ProxyCommon {
    public String getMinecraftVersion() {
        return Loader.instance().getMinecraftModContainer().getVersion();
    }

    public void registerTickHandlers() {
        TickRegistry.registerTickHandler((ITickHandler)new TickHandlerCoreServer(), (Side)Side.SERVER);
    }

    public void addRecipe(ItemStack itemstack, Object[] obj) {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(itemstack, obj));
    }

    public void addShapelessRecipe(ItemStack itemstack, Object[] obj) {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapelessOreRecipe(itemstack, obj));
    }

    public void addSmelting(ItemStack res, ItemStack prod) {
        GameRegistry.addSmelting((int)res.field_77993_c, (ItemStack)prod, (float)0.0f);
    }

    public void dropItemPlayer(EntityPlayer player, ItemStack stack) {
        player.func_71021_b(stack);
    }

    public void setBiomefinderCoordinates(EntityPlayer player, ChunkCoordinates coordinates) {
        if (coordinates != null) {
            ((EntityPlayerMP)player).field_71135_a.func_72567_b(new PacketCoordinates(20, coordinates).getPacket());
        }
    }

    public void removePotionEffect(EntityPlayer player, Potion effect) {
        player.func_70674_bp();
    }

    public String getCurrentLanguage() {
        return null;
    }

    public String getItemDisplayName(Item item) {
        return null;
    }

    public String getDisplayName(ItemStack itemstack) {
        return null;
    }

    public File getForestryRoot() {
        return new File("./");
    }

    public int getByBlockModelId() {
        return 0;
    }

    public boolean isOp(EntityPlayer player) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        return server.func_71203_ab().func_72353_e(player.field_71092_bJ);
    }

    public double getBlockReachDistance(EntityPlayer entityplayer) {
        return 4.0;
    }

    public boolean isSimulating(World world) {
        return true;
    }

    public boolean isShiftDown() {
        return false;
    }

    public boolean isItemStackTagEqual(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public String getItemDisplayName(ItemStack stack) {
        return null;
    }

    public boolean setBlockWithNotify(World world, int x, int y, int z, int blockid) {
        return world.func_72832_d(x, y, z, blockid, 0, 2);
    }

    public void playSoundFX(World world, int x, int y, int z, Block block) {
        Proxies.net.sendNetworkPacket(new PacketFXSignal(PacketFXSignal.SoundFXType.LEAF, x, y, z, block.field_71990_ca, 0), x, y, z);
    }

    public void playSoundFX(World world, int x, int y, int z, String sound, float volume, float pitch) {
    }

    public void addEntityBiodustFX(World world, double d1, double d2, double d3, float f1, float f2, float f3) {
    }

    public void addEntitySwarmFX(World world, double d1, double d2, double d3, float f1, float f2, float f3) {
    }

    public void addEntityExplodeFX(World world, double d1, double d2, double d3, float f1, float f2, float f3) {
    }

    public boolean needsTagCompoundSynched(Item item) {
        return item.func_77651_p();
    }

    public void addBlockDestroyEffects(World world, int xCoord, int yCoord, int zCoord, int blockid, int i) {
        this.sendFXSignal(PacketFXSignal.VisualFXType.BLOCK_DESTROY, PacketFXSignal.SoundFXType.BLOCK_DESTROY, world, xCoord, yCoord, zCoord, blockid, i);
    }

    public void addBlockPlaceEffects(World world, int xCoord, int yCoord, int zCoord, int blockid, int i) {
        this.sendFXSignal(PacketFXSignal.VisualFXType.NONE, PacketFXSignal.SoundFXType.BLOCK_PLACE, world, xCoord, yCoord, zCoord, blockid, i);
    }

    public void playBlockBreakSoundFX(World world, int x, int y, int z, Block block) {
    }

    public void playBlockPlaceSoundFX(World world, int x, int y, int z, Block block) {
    }

    public void sendFXSignal(PacketFXSignal.VisualFXType visualFX, PacketFXSignal.SoundFXType soundFX, World world, int xCoord, int yCoord, int zCoord, int blockid, int i) {
        if (Proxies.common.isSimulating(world)) {
            Proxies.net.sendNetworkPacket(new PacketFXSignal(visualFX, soundFX, xCoord, yCoord, zCoord, blockid, i), xCoord, yCoord, zCoord);
        }
    }

    public void bindTexture(String textureFile) {
    }

    public ITexturePack getSelectedTexturePack(Minecraft minecraft) {
        return null;
    }

    public World getRenderWorld() {
        return null;
    }

    public Minecraft getClientInstance() {
        return FMLClientHandler.instance().getClient();
    }

    public int getBlockModelIdEngine() {
        return 0;
    }

    public void closeGUI(EntityPlayer player) {
        ((EntityPlayerMP)player).func_71053_j();
    }

    public boolean isModLoaded(String modname) {
        return Loader.isModLoaded((String)modname);
    }

    public Object instantiateIfModLoaded(String modname, String className) {
        if (this.isModLoaded(modname)) {
            try {
                Class<?> clas = Class.forName(className, true, Loader.instance().getModClassLoader());
                return clas.newInstance();
            }
            catch (Exception ex) {
                Proxies.log.severe("Failed to load " + className + " even though mod " + modname + " was available.");
                return null;
            }
        }
        return null;
    }
}

