/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.GuiForestry;
import forestry.core.gui.Widget;
import forestry.core.proxy.Proxies;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.item.EnumRarity;
import org.lwjgl.opengl.GL11;

public class WidgetManager {
    public GuiForestry gui;
    public Minecraft minecraft;
    protected ArrayList widgets = new ArrayList();

    public WidgetManager(GuiForestry gui) {
        this.gui = gui;
        this.minecraft = Proxies.common.getClientInstance();
    }

    public void add(Widget slot) {
        this.widgets.add(slot);
    }

    public void remove(Widget slot) {
        this.widgets.remove(slot);
    }

    public void clear() {
        this.widgets.clear();
    }

    protected Widget getAtPosition(int mX, int mY) {
        for (Widget slot : this.widgets) {
            if (!slot.intersectsWith(mX, mY)) continue;
            return slot;
        }
        return null;
    }

    public void drawWidgets() {
        this.gui.setZLevel(100.0f);
        GuiForestry.itemRenderer.field_77023_b = 100.0f;
        for (Widget slot : this.widgets) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            slot.draw(0, 0);
        }
        this.gui.setZLevel(0.0f);
        GuiForestry.itemRenderer.field_77023_b = 0.0f;
    }

    public void drawTooltips(int mouseX, int mouseY) {
        Widget slot = this.getAtPosition(mouseX - this.gui.guiLeft, mouseY - this.gui.guiTop);
        if (slot != null) {
            this.gui.drawTooltip(mouseX, mouseY, 300.0f, slot.getItemNameandInformation(), EnumRarity.common);
        }
    }

    public void handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        Widget slot = this.getAtPosition(mouseX - this.gui.guiLeft, mouseY - this.gui.guiTop);
        if (slot != null) {
            slot.handleMouseClick(mouseX, mouseY, mouseButton);
        }
    }
}

