/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.config.Config;
import forestry.core.gadgets.TileForestry;
import forestry.core.gui.ClimateLedger;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.ErrorLedger;
import forestry.core.gui.HintLedger;
import forestry.core.gui.LedgerManager;
import forestry.core.gui.OwnerLedger;
import forestry.core.gui.PowerLedger;
import forestry.core.gui.WidgetManager;
import forestry.core.interfaces.IClimatised;
import forestry.core.interfaces.IEnergyConsumer;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.IHintSource;
import forestry.core.interfaces.IOwnable;
import forestry.core.proxy.Proxies;
import forestry.core.utils.FontColour;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public abstract class GuiForestry
extends GuiScreen {
    protected WidgetManager widgetManager;
    protected LedgerManager ledgerManager = new LedgerManager(this);
    protected TileForestry tile;
    protected String textureFile;
    protected static RenderItem itemRenderer = new RenderItem();
    protected int xSize = 176;
    protected int ySize = 166;
    public ContainerForestry inventorySlots;
    protected int guiLeft;
    protected int guiTop;
    protected FontColour fontColor;
    protected int playerInventorySize;
    protected int pageCurrent = 0;
    protected int pageSize = 25;
    protected int pageMax = 1;
    protected int column0;
    protected int column1;
    protected int column2;
    private int line;
    protected float factor = 0.75f;

    public GuiForestry(ContainerForestry container) {
        this("", container, null, 1, 0);
    }

    public GuiForestry(String texture, ContainerForestry container) {
        this(texture, container, null, 1, 0);
    }

    public GuiForestry(String texture, ContainerForestry container, Object tile) {
        this(texture, container, tile, 1, 0);
    }

    public GuiForestry(String texture, ContainerForestry container, IInventory tile) {
        this(texture, container, tile, 1, tile.func_70302_i_());
    }

    public GuiForestry(String texture, ContainerForestry container, Object inventory, int pageMax, int pageSize) {
        this.widgetManager = new WidgetManager(this);
        this.ledgerManager = new LedgerManager(this);
        this.textureFile = texture;
        this.inventorySlots = container;
        this.pageMax = pageMax;
        this.pageSize = pageSize;
        if (inventory instanceof TileForestry) {
            this.tile = (TileForestry)inventory;
        }
        this.fontColor = new FontColour(Proxies.common.getSelectedTexturePack(Proxies.common.getClientInstance()));
        this.initLedgers(inventory);
    }

    protected void initLedgers(Object inventory) {
        if (inventory instanceof IErrorSource && ((IErrorSource)inventory).throwsErrors()) {
            this.ledgerManager.add(new ErrorLedger(this.ledgerManager, (IErrorSource)inventory));
        }
        if (inventory instanceof IClimatised && ((IClimatised)inventory).isClimatized()) {
            this.ledgerManager.add(new ClimateLedger(this.ledgerManager, (IClimatised)inventory));
        }
        if (!Config.disableEnergyStat && inventory instanceof IEnergyConsumer && ((IEnergyConsumer)inventory).consumesEnergy()) {
            this.ledgerManager.add(new PowerLedger(this.ledgerManager, (IEnergyConsumer)inventory));
        }
        if (!Config.disableHints && inventory instanceof IHintSource && ((IHintSource)inventory).hasHints()) {
            this.ledgerManager.add(new HintLedger(this.ledgerManager, (IHintSource)inventory));
        }
        if (inventory instanceof IOwnable && ((IOwnable)inventory).isOwnable()) {
            this.ledgerManager.add(new OwnerLedger(this.ledgerManager, (IOwnable)inventory));
        }
    }

    protected final void setFactor(float factor) {
        this.factor = factor;
    }

    protected final void startPage() {
        this.line = 12;
        GL11.glPushMatrix();
        GL11.glScalef((float)this.factor, (float)this.factor, (float)this.factor);
    }

    protected final void startPage(int column0, int column1, int column2) {
        this.column0 = column0;
        this.column1 = column1;
        this.column2 = column2;
        this.startPage();
    }

    protected final int adjustToFactor(int fixed) {
        return (int)((float)fixed * (1.0f / this.factor));
    }

    protected final int getLineY() {
        return this.line;
    }

    protected final void newLine() {
        this.line = (int)((float)this.line + 12.0f * this.factor);
    }

    protected final void newLine(int lineHeight) {
        this.line = (int)((float)this.line + (float)lineHeight * this.factor);
    }

    protected final void endPage() {
        GL11.glPopMatrix();
    }

    protected final void drawRow(String text0, String text1, String text2, int colour0, int colour1, int colour2) {
        this.drawLine(text0, this.column0, colour0);
        this.drawLine(text1, this.column1, colour1);
        this.drawLine(text2, this.column2, colour2);
        this.newLine();
    }

    protected final void drawLine(String text, int x) {
        this.drawLine(text, x, this.fontColor.get("gui.screen"));
    }

    protected final void drawSplitLine(String text, int x, int maxWidth) {
        this.drawSplitLine(text, x, maxWidth, this.fontColor.get("gui.screen"));
    }

    protected final void drawCenteredLine(String text, int x, int width) {
        this.drawCenteredLine(text, x, width, this.fontColor.get("gui.screen"));
    }

    protected final void drawCenteredLine(String text, int x, int width, int color) {
        this.field_73886_k.func_78276_b(text, (int)((float)(this.guiLeft + x) * (1.0f / this.factor)) + (this.adjustToFactor(width) - this.field_73886_k.func_78256_a(text)) / 2, (int)((float)(this.guiTop + this.line) * (1.0f / this.factor)), color);
    }

    protected final void drawLine(String text, int x, int color) {
        this.field_73886_k.func_78276_b(text, (int)((float)(this.guiLeft + x) * (1.0f / this.factor)), (int)((float)(this.guiTop + this.line) * (1.0f / this.factor)), color);
    }

    protected final void drawSplitLine(String text, int x, int maxWidth, int color) {
        this.field_73886_k.func_78279_b(text, (int)((float)(this.guiLeft + x) * (1.0f / this.factor)), (int)((float)(this.guiTop + this.line) * (1.0f / this.factor)), (int)((float)maxWidth * (1.0f / this.factor)), color);
    }

    public void spinTextureIcon(int par1, int par2, Icon par3Icon, int par4, int par5, int rotation) {
        float x = (par1 += this.field_73880_f / 2 - this.xSize / 2) + par4 / 2;
        float y = (par2 += this.field_73881_g / 2 - this.ySize / 2) + par5 / 2;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glRotatef((float)rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + par5), (double)this.field_73735_i, (double)par3Icon.func_94209_e(), (double)par3Icon.func_94210_h());
        tessellator.func_78374_a((double)(par1 + par4), (double)(par2 + par5), (double)this.field_73735_i, (double)par3Icon.func_94212_f(), (double)par3Icon.func_94210_h());
        tessellator.func_78374_a((double)(par1 + par4), (double)(par2 + 0), (double)this.field_73735_i, (double)par3Icon.func_94212_f(), (double)par3Icon.func_94206_g());
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + 0), (double)this.field_73735_i, (double)par3Icon.func_94209_e(), (double)par3Icon.func_94206_g());
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_73882_e.field_71439_g.field_71070_bA = this.inventorySlots;
        this.guiLeft = (this.field_73880_f - this.xSize) / 2;
        this.guiTop = (this.field_73881_g - this.ySize) / 2;
    }

    protected void flipPage(int page) {
        this.pageCurrent = page;
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.xSize);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.field_73886_k.func_78256_a(string)) / 2;
    }

    public void setZLevel(float level) {
        this.field_73735_i = level;
    }

    protected void drawGuiContainerForegroundLayer() {
    }

    protected abstract void drawGuiContainerBackgroundLayer(float var1, int var2, int var3);

    protected void drawTooltip(int mouseX, int mouseY, float zLevel, List information, EnumRarity rarity) {
        if (information.size() > 0) {
            this.field_73735_i = 0.0f;
            GuiForestry.itemRenderer.field_77023_b = 0.0f;
            int tooltipWidth = 0;
            for (int i = 0; i < information.size(); ++i) {
                int textWidth = this.field_73886_k.func_78256_a((String)information.get(i));
                if (textWidth <= tooltipWidth) continue;
                tooltipWidth = textWidth;
            }
            int xPos = mouseX - this.guiLeft + 12;
            int yPos = mouseY - this.guiTop - 12;
            int var14 = 8;
            if (information.size() > 1) {
                var14 += 2 + (information.size() - 1) * 10;
            }
            this.field_73735_i = zLevel;
            GuiForestry.itemRenderer.field_77023_b = zLevel;
            int var15 = -267386864;
            this.func_73733_a(xPos - 3, yPos - 4, xPos + tooltipWidth + 3, yPos - 3, var15, var15);
            this.func_73733_a(xPos - 3, yPos + var14 + 3, xPos + tooltipWidth + 3, yPos + var14 + 4, var15, var15);
            this.func_73733_a(xPos - 3, yPos - 3, xPos + tooltipWidth + 3, yPos + var14 + 3, var15, var15);
            this.func_73733_a(xPos - 4, yPos - 3, xPos - 3, yPos + var14 + 3, var15, var15);
            this.func_73733_a(xPos + tooltipWidth + 3, yPos - 3, xPos + tooltipWidth + 4, yPos + var14 + 3, var15, var15);
            int var16 = 0x505000FF;
            int var17 = (var16 & 0xFEFEFE) >> 1 | var16 & 0xFF000000;
            this.func_73733_a(xPos - 3, yPos - 3 + 1, xPos - 3 + 1, yPos + var14 + 3 - 1, var16, var17);
            this.func_73733_a(xPos + tooltipWidth + 2, yPos - 3 + 1, xPos + tooltipWidth + 3, yPos + var14 + 3 - 1, var16, var17);
            this.func_73733_a(xPos - 3, yPos - 3, xPos + tooltipWidth + 3, yPos - 3 + 1, var16, var16);
            this.func_73733_a(xPos - 3, yPos + var14 + 2, xPos + tooltipWidth + 3, yPos + var14 + 3, var17, var17);
            for (int i = 0; i < information.size(); ++i) {
                String line = (String)information.get(i);
                line = i == 0 ? "\u00a7" + Integer.toHexString(rarity.field_77937_e) + line : "\u00a77" + line;
                this.field_73886_k.func_78261_a(line, xPos, yPos, -1);
                if (i == 0) {
                    yPos += 2;
                }
                yPos += 10;
            }
            this.field_73735_i = 0.0f;
            GuiForestry.itemRenderer.field_77023_b = 0.0f;
        }
    }

    protected void drawBackground() {
        this.drawBackground((this.field_73880_f - this.xSize) / 2, (this.field_73881_g - this.ySize) / 2, this.xSize, this.ySize);
    }

    protected void drawBackground(int x, int y, int w, int h) {
        this.bindTexture();
        this.func_73729_b(x, y, 0, 0, w, h);
    }

    protected void bindTexture() {
        this.bindTexture(this.textureFile);
    }

    protected void bindTexture(String texturePath) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b(texturePath);
    }

    public void func_73863_a(int mouseX, int mouseY, float par3) {
        Slot mousedSlot;
        int i;
        this.func_73873_v_();
        this.drawGuiContainerBackgroundLayer(par3, mouseX, mouseY);
        RenderHelper.func_74520_c();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        Slot mousedOverSlot = null;
        int var7 = 240;
        int var8 = 240;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)var7 / 1.0f), (float)((float)var8 / 1.0f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.pageSize > 0) {
            for (i = this.pageCurrent * this.pageSize; i < (this.pageCurrent + 1) * this.pageSize; ++i) {
                mousedSlot = this.drawSlot(i, mouseX, mouseY);
                if (mousedSlot == null) continue;
                mousedOverSlot = mousedSlot;
            }
        }
        for (i = this.pageMax * this.pageSize; i < this.inventorySlots.field_75151_b.size(); ++i) {
            mousedSlot = this.drawSlot(i, mouseX, mouseY);
            if (mousedSlot == null) continue;
            mousedOverSlot = mousedSlot;
        }
        GL11.glDisable((int)2896);
        this.ledgerManager.drawLedgers();
        this.widgetManager.drawWidgets();
        GL11.glEnable((int)2896);
        this.drawGuiContainerForegroundLayer();
        InventoryPlayer playerInventory = this.field_73882_e.field_71439_g.field_71071_by;
        if (playerInventory.func_70445_o() != null) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
            this.field_73735_i = 200.0f;
            GuiForestry.itemRenderer.field_77023_b = 200.0f;
            itemRenderer.func_82406_b(this.field_73886_k, this.field_73882_e.field_71446_o, playerInventory.func_70445_o(), mouseX - this.guiLeft - 8, mouseY - this.guiTop - 8);
            itemRenderer.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, playerInventory.func_70445_o(), mouseX - this.guiLeft - 8, mouseY - this.guiTop - 8);
            this.field_73735_i = 0.0f;
            GuiForestry.itemRenderer.field_77023_b = 0.0f;
        }
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        if (playerInventory.func_70445_o() == null && mousedOverSlot != null && mousedOverSlot.func_75216_d()) {
            ItemStack slotStack = mousedOverSlot.func_75211_c();
            this.drawTooltip(mouseX, mouseY, 300.0f, slotStack.func_82840_a((EntityPlayer)Proxies.common.getClientInstance().field_71439_g, false), slotStack.func_77953_t());
        }
        this.ledgerManager.drawTooltips(mouseX, mouseY);
        this.widgetManager.drawTooltips(mouseX, mouseY);
        GL11.glPopMatrix();
        super.func_73863_a(mouseX, mouseY, par3);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    protected Slot drawSlot(int slotIndex, int mouseX, int mouseY) {
        Slot mousedOverSlot = null;
        Slot slot = (Slot)this.inventorySlots.field_75151_b.get(slotIndex);
        this.drawSlotInventory(slot);
        if (this.getIsMouseOverSlot(slot, mouseX, mouseY)) {
            mousedOverSlot = slot;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int var9 = slot.field_75223_e;
            int var10 = slot.field_75221_f;
            this.func_73733_a(var9, var10, var9 + 16, var10 + 16, -2130706433, -2130706433);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        return mousedOverSlot;
    }

    protected void drawSlotInventory(Slot slot) {
        Icon icon;
        int xPos = slot.field_75223_e;
        int yPos = slot.field_75221_f;
        ItemStack slotStack = slot.func_75211_c();
        boolean backgroundDrawn = false;
        this.field_73735_i = 100.0f;
        GuiForestry.itemRenderer.field_77023_b = 100.0f;
        if (slotStack == null && (icon = slot.func_75212_b()) != null) {
            GL11.glDisable((int)2896);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_73882_e.field_71446_o.func_98187_b("/gui/items.png");
            this.func_94065_a(xPos, yPos, icon, 16, 16);
            GL11.glEnable((int)2896);
            backgroundDrawn = true;
        }
        if (!backgroundDrawn && slotStack != null) {
            this.drawItemStack(slotStack, xPos, yPos);
        }
        this.field_73735_i = 0.0f;
        GuiForestry.itemRenderer.field_77023_b = 0.0f;
    }

    public void drawItemStack(ItemStack itemstack, int xPos, int yPos) {
        this.field_73735_i = 100.0f;
        GuiForestry.itemRenderer.field_77023_b = 100.0f;
        itemRenderer.func_82406_b(this.field_73886_k, this.field_73882_e.field_71446_o, itemstack, xPos, yPos);
        itemRenderer.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, itemstack, xPos, yPos);
        GuiForestry.itemRenderer.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
    }

    public void func_73733_a(int par1, int par2, int par3, int par4, int par5, int par6) {
        super.func_73733_a(par1, par2, par3, par4, par5, par6);
    }

    protected Slot getSlotAtPosition(int i, int j) {
        Slot slot;
        int k;
        for (k = this.pageCurrent * this.pageSize; k < (this.pageCurrent + 1) * this.pageSize; ++k) {
            slot = (Slot)this.inventorySlots.field_75151_b.get(k);
            if (!this.getIsMouseOverSlot(slot, i, j)) continue;
            return slot;
        }
        for (k = this.pageMax * this.pageSize; k < this.inventorySlots.field_75151_b.size(); ++k) {
            slot = (Slot)this.inventorySlots.field_75151_b.get(k);
            if (!this.getIsMouseOverSlot(slot, i, j)) continue;
            return slot;
        }
        return null;
    }

    protected boolean getIsMouseOverSlot(Slot slot, int i, int j) {
        int k = this.guiLeft;
        int l = this.guiTop;
        return (i -= k) >= slot.field_75223_e - 1 && i < slot.field_75223_e + 16 + 1 && (j -= l) >= slot.field_75221_f - 1 && j < slot.field_75221_f + 16 + 1;
    }

    protected void func_73864_a(int xPos, int yPos, int mouseButton) {
        boolean var4;
        super.func_73864_a(xPos, yPos, mouseButton);
        boolean bl = var4 = mouseButton == this.field_73882_e.field_71474_y.field_74322_I.field_74512_d + 100;
        if (mouseButton == 0 || mouseButton == 1 || var4) {
            Slot slot = this.getSlotAtPosition(xPos, yPos);
            int xStart = this.guiLeft;
            int yStart = this.guiTop;
            boolean var7 = xPos < xStart || yPos < yStart || xPos >= xStart + this.xSize || yPos >= yStart + this.ySize;
            int slotNum = -1;
            if (slot != null) {
                slotNum = slot.field_75222_d;
            }
            if (var7) {
                slotNum = -999;
            }
            if (slotNum != -1) {
                if (var4) {
                    this.handleMouseClick(slot, slotNum, mouseButton, 3);
                } else {
                    boolean var9 = slotNum != -999 && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
                    this.handleMouseClick(slot, slotNum, mouseButton, var9 ? 1 : 0);
                }
            }
        }
        this.ledgerManager.handleMouseClicked(xPos, yPos, mouseButton);
        this.widgetManager.handleMouseClicked(xPos, yPos, mouseButton);
    }

    protected void handleMouseClick(Slot slot, int slotIndex, int mouseButton, int par4) {
        if (slot != null) {
            slotIndex = slot.field_75222_d;
        }
        this.field_73882_e.field_71442_b.func_78753_a(this.inventorySlots.field_75152_c, slotIndex, mouseButton, par4, (EntityPlayer)this.field_73882_e.field_71439_g);
    }

    protected void func_73869_a(char typed, int keycode) {
        if (keycode == 1 || keycode == this.field_73882_e.field_71474_y.field_74315_B.field_74512_d) {
            this.field_73882_e.field_71439_g.func_71053_j();
        }
    }

    public void func_73874_b() {
        if (this.field_73882_e.field_71439_g != null) {
            this.inventorySlots.func_75134_a((EntityPlayer)this.field_73882_e.field_71439_g);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.field_73882_e.field_71439_g.func_70089_S() || this.field_73882_e.field_71439_g.field_70128_L) {
            this.field_73882_e.field_71439_g.func_71053_j();
        }
    }
}

