/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.gadgets.BlockForestry;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TileForestry;
import forestry.core.interfaces.IOwnable;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockBase
extends BlockForestry {
    private final MachineDefinition[] definitions;
    private final boolean hasTESR;

    public BlockBase(int i, Material material, MachineDefinition[] definitions) {
        this(i, material, definitions, false);
    }

    public BlockBase(int id, Material material, MachineDefinition[] definitions, boolean hasTESR) {
        super(id, material);
        this.definitions = definitions;
        this.hasTESR = hasTESR;
        if (hasTESR) {
            Block.field_71982_s[id] = true;
        }
    }

    public boolean func_71926_d() {
        return !this.hasTESR;
    }

    public boolean func_71886_c() {
        return !this.hasTESR;
    }

    public int func_71857_b() {
        if (this.hasTESR) {
            return Proxies.common.getByBlockModelId();
        }
        return 0;
    }

    private int getValidMeta(World world, int x, int y, int z) {
        return this.getValidMeta(world.func_72805_g(x, y, z));
    }

    private int getValidMeta(int metadata) {
        if (metadata >= this.definitions.length || this.definitions[metadata] == null) {
            metadata = 0;
        }
        return metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (MachineDefinition definition : this.definitions) {
            if (definition == null) continue;
            definition.getSubBlocks(id, tab, list);
        }
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata >= this.definitions.length || this.definitions[metadata] == null) {
            metadata = 0;
        }
        return this.definitions[metadata].createMachine();
    }

    public TileEntity func_72274_a(World world) {
        return this.createTileEntity(world, 0);
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        if (this.definitions[this.getValidMeta(metadata)].handlesDrops()) {
            return this.definitions[this.getValidMeta(metadata)].getBlockDropped(world, x, y, z, metadata, fortune);
        }
        return super.getBlockDropped(world, x, y, z, metadata, fortune);
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        int metadata = this.getValidMeta(world, x, y, z);
        return this.definitions[metadata].isBlockSolidOnSide(world, x, y, z, side);
    }

    @Override
    public void func_71860_a(World world, int i, int j, int k, EntityLiving entityliving, ItemStack itemstack) {
        super.func_71860_a(world, i, j, k, entityliving, itemstack);
        TileForestry tile = (TileForestry)world.func_72796_p(i, j, k);
        tile.rotateAfterPlacement(world, i, j, k, entityliving, itemstack);
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        int metadata = this.getValidMeta(world, x, y, z);
        if (this.definitions[metadata].onBlockActivated(world, x, y, z, player, par6, par7, par8, par9)) {
            return true;
        }
        if (player.func_70093_af()) {
            return false;
        }
        TileBase tile = (TileBase)world.func_72796_p(x, y, z);
        if (!tile.func_70300_a(player)) {
            return false;
        }
        if (!Proxies.common.isSimulating(world)) {
            return true;
        }
        if (tile.allowsInteraction(player)) {
            tile.openGui(player, tile);
        } else {
            player.func_71035_c("\u00a7c" + tile.getOwnerName() + " " + StringUtil.localize("chat.accesslocked"));
        }
        return true;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        return this.definitions[this.getValidMeta(world, x, y, z)].rotateBlock(world, x, y, z, axis);
    }

    public void func_71861_g(World world, int x, int y, int z) {
        super.func_71861_g(world, x, y, z);
        this.definitions[this.getValidMeta(world, x, y, z)].onBlockAdded(world, x, y, z);
    }

    @Override
    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        IOwnable tile = (IOwnable)world.func_72796_p(x, y, z);
        if (tile.isOwnable() && !tile.allowsRemoval(player)) {
            return false;
        }
        if (this.definitions[this.getValidMeta(world, x, y, z)].removeBlockByPlayer(world, player, x, y, z)) {
            return world.func_94571_i(x, y, z);
        }
        return false;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata >= this.definitions.length || this.definitions[metadata] == null) {
            metadata = 0;
        }
        return this.definitions[metadata].canConnectRedstone(world, x, y, z, side);
    }

    public int func_71899_b(int metadata) {
        return metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        for (MachineDefinition def : this.definitions) {
            def.registerIcons(register);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int metadata) {
        if (metadata >= this.definitions.length || this.definitions[metadata] == null) {
            metadata = 0;
        }
        return this.definitions[metadata].getBlockTextureFromSideAndMetadata(side, metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata >= this.definitions.length || this.definitions[metadata] == null) {
            metadata = 0;
        }
        return this.definitions[metadata].getBlockTexture(world, x, y, z, side, metadata);
    }
}

