/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.config.ForestryBlock;
import forestry.core.worldgen.BlockType;
import forestry.core.worldgen.WorldGenBase;

public class WorldGenBalsa
extends WorldGenTree {
    public WorldGenBalsa(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        int leafSpawn = this.height;
        this.addLeaf(0, leafSpawn--, 0, WorldGenBase.EnumReplaceMode.NONE);
        this.generateAdjustedCylinder(leafSpawn--, 0.0f, 1, this.leaf);
        if (this.height > 10) {
            this.generateAdjustedCylinder(leafSpawn--, 0.0f, 1, this.leaf);
        }
        --leafSpawn;
        while (leafSpawn > 6) {
            this.generateAdjustedCylinder(leafSpawn, 0.0f, 1, this.leaf);
            --leafSpawn;
        }
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(6, 6);
        this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
    }

    @Override
    public BlockType getWood() {
        return new BlockType(ForestryBlock.log3.field_71990_ca, 3);
    }
}

