/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodType;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockLog
extends Block
implements IWoodTyped {
    private LogCat cat;

    public BlockLog(int id, LogCat cat) {
        super(id, Material.field_76245_d);
        this.cat = cat;
        this.func_71848_c(2.0f);
        this.func_71894_b(5.0f);
        this.func_71884_a(field_71967_e);
        this.func_71849_a(Tabs.tabArboriculture);
    }

    public static int getTypeFromMeta(int damage) {
        return damage & 3;
    }

    public int func_71857_b() {
        return Block.field_71951_J.func_71857_b();
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        int radius = 4;
        int boundary = radius + 1;
        if (world.func_72904_c(x - boundary, y - boundary, z - boundary, x + boundary, y + boundary, z + boundary)) {
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    for (int k = -radius; k <= radius; ++k) {
                        int blockid = world.func_72798_a(x + i, y + j, z + k);
                        if (Block.field_71973_m[blockid] == null) continue;
                        Block.field_71973_m[blockid].beginLeavesDecay(world, x + i, y + j, z + k);
                    }
                }
            }
        }
    }

    public int func_85104_a(World world, int x, int y, int z, int side, float par6, float par7, float par8, int meta) {
        int type = BlockLog.getTypeFromMeta(meta);
        int b0 = 0;
        switch (side) {
            case 0: 
            case 1: {
                b0 = 0;
                break;
            }
            case 2: 
            case 3: {
                b0 = 8;
                break;
            }
            case 4: 
            case 5: {
                b0 = 4;
            }
        }
        return type | b0;
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        if (this.cat == LogCat.CAT6) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            itemList.add(new ItemStack((Block)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        WoodType.registerIcons();
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        int oriented = meta & 0xC;
        WoodType type = this.getWoodType(BlockLog.getTypeFromMeta(meta));
        switch (oriented) {
            case 4: {
                if (side > 3) {
                    return type.getHeartIcon();
                }
                return type.getBarkIcon();
            }
            case 8: {
                if (side == 2 || side == 3) {
                    return type.getHeartIcon();
                }
                return type.getBarkIcon();
            }
        }
        if (side < 2) {
            return type.getHeartIcon();
        }
        return type.getBarkIcon();
    }

    public int func_71899_b(int meta) {
        return BlockLog.getTypeFromMeta(meta);
    }

    protected ItemStack func_71880_c_(int meta) {
        return new ItemStack(this.field_71990_ca, 1, BlockLog.getTypeFromMeta(meta));
    }

    public float func_71934_m(World world, int x, int y, int z) {
        return this.getWoodType(BlockLog.getTypeFromMeta(world.func_72805_g(x, y, z))).getHardness();
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return 20;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return true;
    }

    public int getFireSpreadSpeed(World world, int x, int y, int z, int metadata, ForgeDirection face) {
        if (face == ForgeDirection.DOWN) {
            return 20;
        }
        if (face != ForgeDirection.UP) {
            return 10;
        }
        return 5;
    }

    public boolean canSustainLeaves(World world, int x, int y, int z) {
        return true;
    }

    public boolean isWood(World world, int x, int y, int z) {
        return true;
    }

    @Override
    public WoodType getWoodType(int meta) {
        if (meta + this.cat.ordinal() * 4 < WoodType.VALUES.length) {
            return WoodType.VALUES[meta + this.cat.ordinal() * 4];
        }
        return WoodType.LARCH;
    }

    @Override
    public String getBlockKind() {
        return "log";
    }

    public static enum LogCat {
        CAT0,
        CAT1,
        CAT2,
        CAT3,
        CAT4,
        CAT5,
        CAT6,
        CAT7;

    }
}

