/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IToolGrafter;
import forestry.api.arboriculture.ITree;
import forestry.api.core.IToolScoop;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IButterfly;
import forestry.arboriculture.gadgets.BlockTreeContainer;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.StackUtils;
import forestry.plugins.PluginArboriculture;
import forestry.plugins.PluginLepidopterology;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockLeaves
extends BlockTreeContainer {
    int[] adjacentTreeBlocks;
    @SideOnly(value=Side.CLIENT)
    private static Icon defaultIcon;

    public BlockLeaves(int id) {
        super(id, Material.field_76257_i);
        this.func_71907_b(true);
        this.func_71848_c(0.2f);
        this.func_71868_h(1);
        this.func_71884_a(field_71965_g);
    }

    public static TileLeaves getLeafTile(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileLeaves)) {
            return null;
        }
        return (TileLeaves)tile;
    }

    public TileEntity func_72274_a(World world) {
        return new TileLeaves();
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        ItemStack held;
        int metadata = world.func_72805_g(x, y, z);
        if (Proxies.common.isSimulating(world) && this.canHarvestBlock(player, metadata) && (held = player.field_71071_by.func_70448_g()) != null && held.func_77973_b() instanceof IToolGrafter) {
            float saplingModifier = 1.0f;
            saplingModifier = ((IToolGrafter)held.func_77973_b()).getSaplingModifier(held, world, player, x, y, z);
            held.func_77972_a(1, (EntityLiving)player);
            if (held.field_77994_a <= 0) {
                player.func_71028_bD();
            }
            this.spawnLeafDrops(world, x, y, z, metadata, saplingModifier, false);
        }
        return world.func_72832_d(x, y, z, 0, 0, 3);
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int metadata) {
        int offset = 1;
        int shift = offset + 1;
        if (world.func_72904_c(x - shift, y - shift, z - shift, x + shift, y + shift, z + shift)) {
            for (int i = -offset; i <= offset; ++i) {
                for (int j = -offset; j <= offset; ++j) {
                    for (int k = -offset; k <= offset; ++k) {
                        int block = world.func_72798_a(x + i, y + j, z + k);
                        if (Block.field_71973_m[block] == null) continue;
                        Block.field_71973_m[block].beginLeavesDecay(world, x + i, y + j, z + k);
                    }
                }
            }
        }
        this.spawnLeafDrops(world, x, y, z, metadata, 1.0f, true);
        super.func_71852_a(world, x, y, z, par5, metadata);
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        return StackUtils.EMPTY_STACK_LIST;
    }

    private void removeLeaves(World world, int x, int y, int z) {
        this.spawnLeafDrops(world, x, y, z, world.func_72805_g(x, y, z), 1.0f, true);
        world.func_94571_i(x, y, z);
    }

    private void spawnLeafDrops(World world, int x, int y, int z, int metadata, float saplingModifier, boolean doFruitDrop) {
        for (ItemStack drop : this.getLeafDrop(world, x, y, z, metadata, saplingModifier, doFruitDrop)) {
            if (drop == null) continue;
            StackUtils.dropItemStackAsEntity(drop, world, x, y, z);
        }
    }

    private ArrayList getLeafDrop(World world, int x, int y, int z, int metadata, float saplingModifier, boolean doFruitDrop) {
        ITree[] saplings;
        ArrayList<Object> prod = new ArrayList<Object>();
        TileLeaves tile = BlockLeaves.getLeafTile((IBlockAccess)world, x, y, z);
        if (tile == null) {
            return prod;
        }
        if (tile.getTree() == null) {
            return prod;
        }
        for (ITree iTree : saplings = tile.getTree().getSaplings(world, x, y, z, saplingModifier)) {
            if (iTree == null) continue;
            prod.add(PluginArboriculture.treeInterface.getMemberStack(iTree, EnumGermlingType.SAPLING.ordinal()));
        }
        if (doFruitDrop && tile.hasFruit()) {
            for (ITree iTree : tile.getTree().produceStacks(world, x, y, z, tile.getRipeningTime())) {
                prod.add(iTree);
            }
        }
        return prod;
    }

    public boolean func_71926_d() {
        return !Proxies.render.fancyGraphicsEnabled();
    }

    public int func_71857_b() {
        return PluginArboriculture.modelIdLeaves;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71933_m() {
        double var1 = 0.5;
        double var3 = 1.0;
        return ColorizerFoliage.func_77470_a((double)var1, (double)var3);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71920_b(IBlockAccess world, int x, int y, int z) {
        TileLeaves leaves = BlockLeaves.getLeafTile(world, x, y, z);
        if (leaves == null) {
            return ColorizerFoliage.func_77468_c();
        }
        int colour = leaves.getFoliageColour((EntityPlayer)Proxies.common.getClientInstance().field_71439_g);
        if (colour == PluginArboriculture.proxy.getFoliageColorBasic()) {
            colour = world.func_72807_a(x, z).func_76726_l();
        }
        return colour;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        defaultIcon = TextureManager.getInstance().registerTerrainTex("leaves/deciduous.fancy");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int metadata) {
        return defaultIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TileLeaves leaves = BlockLeaves.getLeafTile(world, x, y, z);
        if (leaves != null) {
            return leaves.getBlockTexture(Proxies.render.fancyGraphicsEnabled());
        }
        return defaultIcon;
    }

    @Override
    public void func_71847_b(World world, int x, int y, int z, Random random) {
        super.func_71847_b(world, x, y, z, random);
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        if ((meta & 8) != 0 && (meta & 4) == 0) {
            int var12;
            int offset = 4;
            int shift = offset + 1;
            int var9 = 32;
            int var10 = var9 * var9;
            int var11 = var9 / 2;
            if (this.adjacentTreeBlocks == null) {
                this.adjacentTreeBlocks = new int[var9 * var9 * var9];
            }
            if (world.func_72904_c(x - shift, y - shift, z - shift, x + shift, y + shift, z + shift)) {
                int var15;
                int var14;
                int var13;
                for (var12 = -offset; var12 <= offset; ++var12) {
                    for (var13 = -offset; var13 <= offset; ++var13) {
                        for (var14 = -offset; var14 <= offset; ++var14) {
                            var15 = world.func_72798_a(x + var12, y + var13, z + var14);
                            Block block = Block.field_71973_m[var15];
                            this.adjacentTreeBlocks[(var12 + var11) * var10 + (var13 + var11) * var9 + var14 + var11] = block != null && block.canSustainLeaves(world, x + var12, y + var13, z + var14) ? 0 : (block != null && block.isLeaves(world, x + var12, y + var13, z + var14) ? -2 : -1);
                        }
                    }
                }
                for (var12 = 1; var12 <= 4; ++var12) {
                    for (var13 = -offset; var13 <= offset; ++var13) {
                        for (var14 = -offset; var14 <= offset; ++var14) {
                            for (var15 = -offset; var15 <= offset; ++var15) {
                                if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + var15 + var11] != var12 - 1) continue;
                                if (this.adjacentTreeBlocks[(var13 + var11 - 1) * var10 + (var14 + var11) * var9 + var15 + var11] == -2) {
                                    this.adjacentTreeBlocks[(var13 + var11 - 1) * var10 + (var14 + var11) * var9 + var15 + var11] = var12;
                                }
                                if (this.adjacentTreeBlocks[(var13 + var11 + 1) * var10 + (var14 + var11) * var9 + var15 + var11] == -2) {
                                    this.adjacentTreeBlocks[(var13 + var11 + 1) * var10 + (var14 + var11) * var9 + var15 + var11] = var12;
                                }
                                if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11 - 1) * var9 + var15 + var11] == -2) {
                                    this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11 - 1) * var9 + var15 + var11] = var12;
                                }
                                if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11 + 1) * var9 + var15 + var11] == -2) {
                                    this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11 + 1) * var9 + var15 + var11] = var12;
                                }
                                if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + (var15 + var11 - 1)] == -2) {
                                    this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + (var15 + var11 - 1)] = var12;
                                }
                                if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + var15 + var11 + 1] != -2) continue;
                                this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + var15 + var11 + 1] = var12;
                            }
                        }
                    }
                }
            }
            if ((var12 = this.adjacentTreeBlocks[var11 * var10 + var11 * var9 + var11]) >= 0) {
                world.func_72921_c(x, y, z, meta & 0xFFFFFFF7, 2);
            } else {
                this.removeLeaves(world, x, y, z);
            }
        }
    }

    public void beginLeavesDecay(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) | 8, 2);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return 60;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return true;
    }

    public int getFireSpreadSpeed(World world, int x, int y, int z, int metadata, ForgeDirection face) {
        if (face == ForgeDirection.DOWN) {
            return 20;
        }
        if (face != ForgeDirection.UP) {
            return 10;
        }
        return 5;
    }

    public boolean isLeaves(World world, int x, int y, int z) {
        return true;
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        IButterfly caterpillar;
        ItemStack heldItem = player.func_70694_bm();
        TileEntity tile = world.func_72796_p(x, y, z);
        IButterfly iButterfly = caterpillar = tile instanceof TileLeaves ? ((TileLeaves)tile).getCaterpillar() : null;
        if (heldItem != null && heldItem.func_77973_b() instanceof IToolScoop && caterpillar != null) {
            StackUtils.dropItemStackAsEntity(PluginLepidopterology.butterflyInterface.getMemberStack(caterpillar, EnumFlutterType.CATERPILLAR.ordinal()), world, x, y, z);
            ((TileLeaves)tile).setCaterpillar(null);
            return true;
        }
        return super.func_71903_a(world, x, y, z, player, par6, par7, par8, par9);
    }
}

