/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.render.TextureManager;
import java.util.Locale;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public enum WoodType {
    LARCH,
    TEAK,
    ACACIA,
    LIME,
    CHESTNUT,
    WENGE,
    BAOBAB,
    SEQUOIA(4.0f),
    KAPOK,
    EBONY,
    MAHOGANY,
    BALSA(1.0f),
    WILLOW,
    WALNUT,
    GREENHEART(7.5f),
    CHERRY,
    MAHOE,
    POPLAR,
    PALM,
    PAPAYA,
    PINE(3.0f),
    PLUM,
    MAPLE,
    CITRUS,
    GIGANTEUM(2.0f, false);

    public static final WoodType[] VALUES;
    private final float hardness;
    public final boolean hasPlank;
    @SideOnly(value=Side.CLIENT)
    private static Icon[][] icons;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private WoodType() {
        this((String)var1_-1, (int)var2_-1, 2.0f, true);
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private WoodType() {
        this((String)var1_-1, (int)var2_-1, (float)hardness, true);
        void hardness;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - void declaration
     */
    private WoodType() {
        void hasPlank;
        void hardness;
        this.hardness = hardness;
        this.hasPlank = hasPlank;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons() {
        int i;
        icons = new Icon[3][VALUES.length];
        for (i = 0; i < VALUES.length; ++i) {
            WoodType.icons[0][i] = TextureManager.getInstance().registerTerrainTex("wood/planks." + VALUES[i].toString().toLowerCase(Locale.ENGLISH));
        }
        for (i = 0; i < VALUES.length; ++i) {
            WoodType.icons[1][i] = TextureManager.getInstance().registerTerrainTex("wood/bark." + VALUES[i].toString().toLowerCase(Locale.ENGLISH));
        }
        for (i = 0; i < VALUES.length; ++i) {
            WoodType.icons[2][i] = TextureManager.getInstance().registerTerrainTex("wood/heart." + VALUES[i].toString().toLowerCase(Locale.ENGLISH));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getPlankIcon() {
        return icons[0][this.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getBarkIcon() {
        return icons[1][this.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getHeartIcon() {
        return icons[2][this.ordinal()];
    }

    public float getHardness() {
        return this.hardness;
    }

    public void saveToCompound(NBTTagCompound compound) {
        compound.func_74768_a("WoodType", this.ordinal());
    }

    public static WoodType getFromCompound(NBTTagCompound compound) {
        int typeOrdinal;
        if (compound != null && (typeOrdinal = compound.func_74762_e("WoodType")) < VALUES.length) {
            return VALUES[typeOrdinal];
        }
        return LARCH;
    }

    static {
        VALUES = WoodType.values();
    }
}

