/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.core;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ForestryAPI;
import java.util.ArrayList;
import net.minecraft.util.Icon;

public enum EnumTemperature {
    NONE("None", "habitats/ocean"),
    ICY("Icy", "habitats/snow"),
    COLD("Cold", "habitats/taiga"),
    NORMAL("Normal", "habitats/plains"),
    WARM("Warm", "habitats/jungle"),
    HOT("Hot", "habitats/desert"),
    HELLISH("Hellish", "habitats/nether");

    public static ArrayList icyBiomeIds;
    public static ArrayList coldBiomeIds;
    public static ArrayList normalBiomeIds;
    public static ArrayList warmBiomeIds;
    public static ArrayList hotBiomeIds;
    public static ArrayList hellishBiomeIds;
    public final String name;
    public final String iconIndex;

    /*
     * WARNING - void declaration
     */
    private EnumTemperature() {
        void iconIndex;
        void name;
        this.name = name;
        this.iconIndex = iconIndex;
    }

    public String getName() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        return ForestryAPI.textureManager.getDefault(this.iconIndex);
    }

    public static ArrayList getBiomeIds(EnumTemperature temperature) {
        switch (temperature) {
            case ICY: {
                return icyBiomeIds;
            }
            case COLD: {
                return coldBiomeIds;
            }
            case WARM: {
                return warmBiomeIds;
            }
            case HOT: {
                return hotBiomeIds;
            }
            case HELLISH: {
                return hellishBiomeIds;
            }
        }
        return normalBiomeIds;
    }

    static {
        icyBiomeIds = new ArrayList();
        coldBiomeIds = new ArrayList();
        normalBiomeIds = new ArrayList();
        warmBiomeIds = new ArrayList();
        hotBiomeIds = new ArrayList();
        hellishBiomeIds = new ArrayList();
    }
}

