/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.relauncher;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.IDownloadDisplay;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class Downloader
extends JOptionPane
implements IDownloadDisplay {
    private JDialog container;
    private JLabel currentActivity;
    private JProgressBar progress;
    boolean stopIt;
    Thread pokeThread;

    private Box makeProgressPanel() {
        Box box = Box.createVerticalBox();
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel welcomeLabel = new JLabel("<html><b><font size='+1'>FML is setting up your minecraft environment</font></b></html>");
        box.add(welcomeLabel);
        welcomeLabel.setAlignmentY(0.0f);
        welcomeLabel = new JLabel("<html>Please wait, FML has some tasks to do before you can play</html>");
        welcomeLabel.setAlignmentY(0.0f);
        box.add(welcomeLabel);
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        this.currentActivity = new JLabel("Currently doing ...");
        box.add(this.currentActivity);
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        this.progress = new JProgressBar(0, 100);
        this.progress.setStringPainted(true);
        box.add(this.progress);
        box.add(Box.createRigidArea(new Dimension(0, 30)));
        return box;
    }

    @Override
    public JDialog makeDialog() {
        this.setMessageType(1);
        this.setMessage(this.makeProgressPanel());
        this.setOptions(new Object[]{"Stop"});
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() == Downloader.this && evt.getPropertyName() == "value") {
                    Downloader.this.requestClose("This will stop minecraft from launching\nAre you sure you want to do this?");
                }
            }
        });
        this.container = new JDialog(null, "Hello", Dialog.ModalityType.MODELESS);
        this.container.setResizable(false);
        this.container.setLocationRelativeTo(null);
        this.container.add(this);
        this.updateUI();
        this.container.pack();
        this.container.setMinimumSize(this.container.getPreferredSize());
        this.container.setVisible(true);
        this.container.setDefaultCloseOperation(0);
        this.container.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                Downloader.this.requestClose("Closing this window will stop minecraft from launching\nAre you sure you wish to do this?");
            }
        });
        return this.container;
    }

    protected void requestClose(String message) {
        int shouldClose = JOptionPane.showConfirmDialog(this.container, message, "Are you sure you want to stop?", 0, 2);
        if (shouldClose == 0) {
            this.container.dispose();
        }
        this.stopIt = true;
        if (this.pokeThread != null) {
            this.pokeThread.interrupt();
        }
    }

    @Override
    public void updateProgressString(String progressUpdate, Object ... data) {
        FMLLog.finest(progressUpdate, data);
        if (this.currentActivity != null) {
            this.currentActivity.setText(String.format(progressUpdate, data));
        }
    }

    @Override
    public void resetProgress(int sizeGuess) {
        if (this.progress != null) {
            this.progress.getModel().setRangeProperties(0, 0, 0, sizeGuess, false);
        }
    }

    @Override
    public void updateProgress(int fullLength) {
        if (this.progress != null) {
            this.progress.getModel().setValue(fullLength);
        }
    }

    @Override
    public void makeHeadless() {
        this.container = null;
        this.progress = null;
        this.currentActivity = null;
    }

    @Override
    public void setPokeThread(Thread currentThread) {
        this.pokeThread = currentThread;
    }

    @Override
    public boolean shouldStopIt() {
        return this.stopIt;
    }
}

