/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.minecraft.GameUpdater;
import net.minecraft.TransparentLabel;
import net.minecraft.Util;

public class OptionsPanel
extends JDialog {
    private static final long serialVersionUID = 1L;

    public OptionsPanel(Frame parent) {
        super(parent);
        this.setModal(true);
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel("Launcher options", 0);
        label.setBorder(new EmptyBorder(0, 0, 16, 0));
        label.setFont(new Font("Default", 1, 16));
        panel.add((Component)label, "North");
        JPanel optionsPanel = new JPanel(new BorderLayout());
        JPanel labelPanel = new JPanel(new GridLayout(0, 1));
        JPanel fieldPanel = new JPanel(new GridLayout(0, 1));
        optionsPanel.add((Component)labelPanel, "West");
        optionsPanel.add((Component)fieldPanel, "Center");
        final JButton forceButton = new JButton("Force update!");
        forceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GameUpdater.forceUpdate = 1;
                forceButton.setText("Will force!");
                forceButton.setEnabled(false);
            }
        });
        labelPanel.add(new JLabel("Force game update: ", 4));
        fieldPanel.add(forceButton);
        labelPanel.add(new JLabel("Game location on disk: ", 4));
        TransparentLabel dirLink = new TransparentLabel(Util.getWorkingDirectory().toString()){
            private static final long serialVersionUID = 0L;

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                int x = 0;
                int y = 0;
                FontMetrics fm = g.getFontMetrics();
                int width = fm.stringWidth(this.getText());
                int height = fm.getHeight();
                if (this.getAlignmentX() == 2.0f) {
                    x = 0;
                } else if (this.getAlignmentX() == 0.0f) {
                    x = this.getBounds().width / 2 - width / 2;
                } else if (this.getAlignmentX() == 4.0f) {
                    x = this.getBounds().width - width;
                }
                y = this.getBounds().height / 2 + height / 2 - 1;
                g.drawLine(x + 2, y, x + width - 2, y);
            }

            @Override
            public void update(Graphics g) {
                this.paint(g);
            }
        };
        dirLink.setCursor(Cursor.getPredefinedCursor(12));
        dirLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                try {
                    Util.openLink(new URL("file://" + Util.getWorkingDirectory().getAbsolutePath()).toURI());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        dirLink.setForeground(new Color(0x2020FF));
        fieldPanel.add(dirLink);
        panel.add((Component)optionsPanel, "Center");
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        buttonsPanel.add((Component)new JPanel(), "Center");
        JButton doneButton = new JButton("Done");
        doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                OptionsPanel.this.setVisible(false);
            }
        });
        buttonsPanel.add((Component)doneButton, "East");
        buttonsPanel.setBorder(new EmptyBorder(16, 0, 0, 0));
        panel.add((Component)buttonsPanel, "South");
        this.add(panel);
        panel.setBorder(new EmptyBorder(16, 24, 24, 24));
        this.pack();
        this.setLocationRelativeTo(parent);
    }
}

