/*
 * Decompiled with CFR 0.152.
 */
package data;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import java.util.HashMap;
import java.util.Map;

public class TextureManager {
    static Map<String, Texture> textures = new HashMap<String, Texture>();
    static Map<String, Pixmap> pixs = new HashMap<String, Pixmap>();

    public static Texture get(String filename) {
        if (textures.get(filename) == null) {
            try {
                Texture t = new Texture(Gdx.files.internal(filename));
                t.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
                textures.put(filename, t);
                System.out.println("[LOAD][TEXTURE] loaded : " + filename);
            }
            catch (Exception e) {
                System.out.println("Couldn't load texture : " + filename);
                e.printStackTrace();
                System.exit(0);
            }
        }
        return textures.get(filename);
    }

    public static Pixmap getPixmap(String filename) {
        if (pixs.get(filename) == null) {
            try {
                pixs.put(filename, new Pixmap(Gdx.files.internal(filename)));
            }
            catch (Exception e) {
                System.out.println("Couldn't find pixmap : " + filename);
                e.printStackTrace();
                System.exit(0);
            }
        }
        return pixs.get(filename);
    }

    public static void drawCentered(Batch sb, String path, float x, float y) {
        Texture t = TextureManager.get(path);
        sb.draw(t, x - (float)t.getWidth() / 2.0f, y - (float)t.getHeight() / 2.0f);
    }

    public static void drawRotated(Batch sb, String path, float x, float y, float angle) {
        Texture t = TextureManager.get(path);
        sb.draw(t, x, y, (float)t.getWidth() / 2.0f, (float)t.getHeight() / 2.0f, (float)t.getWidth(), (float)t.getHeight(), 1.0f, 1.0f, angle, 0, 0, t.getWidth(), t.getHeight(), false, false);
    }

    public static void drawRotatedCentered(Batch sb, String path, float x, float y, float angle) {
        Texture t = TextureManager.get(path);
        TextureManager.drawRotated(sb, path, x - (float)t.getWidth() / 2.0f, y - (float)t.getHeight() / 2.0f, angle);
    }

    public static void drawRotatedCenteredOrigin(Batch sb, String path, float x, float y, float angle, float originX, float originY) {
        Texture t = TextureManager.get(path);
        sb.draw(t, x - (float)t.getWidth() / 2.0f, y - (float)t.getHeight() / 2.0f, originX += (float)t.getWidth() / 2.0f, originY += (float)t.getHeight() / 2.0f, (float)t.getWidth(), (float)t.getHeight(), 1.0f, 1.0f, angle, 0, 0, t.getWidth(), t.getHeight(), false, false);
    }
}

