/*
 * Decompiled with CFR 0.152.
 */
package com.uriopass.ezchat;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.widget.VisTextArea;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.uriopass.ezchat.ClientMe;
import com.uriopass.ezchat.ServerMe;
import data.GSB;
import java.io.IOException;

public class EzChatMain
extends ApplicationAdapter {
    Stage s;
    VisTextArea receiveBox;
    VisTextField messageBox;
    ClientMe cli;
    ServerMe serv;

    public void create() {
        GSB.init();
        VisUI.load();
        FileHandle fh = Gdx.files.external(".ezchat/EzChat-preferences.ini");
        if (!fh.exists()) {
            try {
                fh.file().createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            fh.writeString("0 localhost", true);
        } else {
            System.out.println(fh.file().getAbsolutePath());
        }
        String[] prefs = fh.readString().split(" ");
        if (prefs.length != 2) {
            throw new RuntimeException("Error, preferences file is wrong");
        }
        this.receiveBox = new VisTextArea();
        this.receiveBox.setInputValid(false);
        this.receiveBox.setBounds(0.0f, 50.0f, (float)Gdx.graphics.getWidth(), (float)(Gdx.graphics.getHeight() - 50));
        this.messageBox = new VisTextField();
        this.messageBox.setMessageText("Message, press Enter to send");
        this.messageBox.setBounds(0.0f, 0.0f, (float)Gdx.graphics.getWidth(), 50.0f);
        if (prefs[0].equals("1")) {
            this.serv = new ServerMe();
            this.serv.start();
        }
        this.cli = new ClientMe((VisTextField)this.receiveBox, prefs[1]);
        this.cli.start();
    }

    public void render() {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.s.act();
        this.s.draw();
        if (Gdx.input.isKeyJustPressed(66)) {
            String s = this.messageBox.getText();
            s.replaceAll("\n", "");
            if (this.cli.send(s)) {
                this.messageBox.setText("");
            }
        }
    }

    public void resize(int width, int height) {
        GSB.updateSize(width, height);
        this.messageBox.setBounds(0.0f, 0.0f, (float)width, 50.0f);
        this.receiveBox.setBounds(0.0f, 50.0f, (float)width, (float)(height - 50));
        this.s = new Stage();
        this.s.addActor((Actor)this.receiveBox);
        this.s.addActor((Actor)this.messageBox);
        this.s.setKeyboardFocus((Actor)this.messageBox);
        Gdx.input.setInputProcessor((InputProcessor)this.s);
    }

    public void dispose() {
        if (this.serv != null) {
            this.serv.dispose();
            this.serv.stop();
        }
        this.cli.dispose();
        this.cli.stop();
    }
}

