/*
 * Decompiled with CFR 0.152.
 */
package ui_buttons;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import data.FontManager;
import data.GSB;
import data.SpriteManager;
import game.Constants;
import ui_buttons.ButtonType;

public class BigButton {
    String name;
    ButtonType position = ButtonType.NONE;
    String mainPath = "mainmenu_button";
    int x = 0;
    int originalY = 0;
    int drawy;
    int width;
    int height;
    int fontSize = Constants.hudSize;
    GlyphLayout gl = new GlyphLayout();
    int test = 0;

    public BigButton(String name) {
        this.name = name;
        this.width = 200;
        this.height = 50;
        this.gl.setText(FontManager.get(this.fontSize), name);
        this.fontSize = Constants.hudSize;
    }

    public void render(int scroll) {
        this.drawy = this.originalY + scroll;
        String path = "";
        switch (this.position) {
            case HOVER: {
                path = this.mainPath + "_hover.png";
                break;
            }
            case CLICK: {
                path = this.mainPath + "_click.png";
                break;
            }
            default: {
                path = this.mainPath + ".png";
            }
        }
        SpriteManager.get(path).setPosition(this.x, this.drawy);
        SpriteManager.get(path).setSize(this.width, this.height);
        SpriteManager.get(path).draw(GSB.hud);
        FontManager.get(this.fontSize).draw((Batch)GSB.hud, this.name, (float)this.x + ((float)this.width - this.gl.width) / 2.0f, (float)this.drawy + ((float)this.height + this.gl.height) / 2.0f);
    }

    public void setMainPath(String mainPath) {
        this.mainPath = mainPath;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.gl.setText(FontManager.get(fontSize), this.name);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isHovered() {
        return this.position == ButtonType.HOVER || this.position == ButtonType.CLICK;
    }

    public String getName() {
        return this.name;
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.originalY = y;
        this.drawy = y;
    }

    public void center(boolean x, boolean y) {
        if (x) {
            this.x -= this.width / 2;
        }
        if (y) {
            this.originalY -= this.height / 2;
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.drawy;
    }

    boolean contains(int x, int y) {
        return x > this.x && y > this.drawy && x < this.x + this.width && y < this.drawy + this.height;
    }

    public void update() {
        int y;
        int x = Gdx.input.getX();
        if (this.contains(x, y = Gdx.graphics.getHeight() - Gdx.input.getY())) {
            if (Gdx.input.isButtonPressed(0)) {
                if (Gdx.input.justTouched()) {
                    this.onClick();
                }
                this.position = ButtonType.CLICK;
            } else {
                this.position = ButtonType.NONE;
            }
        } else {
            this.position = ButtonType.NONE;
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    protected void onClick() {
    }

    public void forceClick() {
        this.onClick();
    }
}

