/*
 * Decompiled with CFR 0.152.
 */
package ui_buttons;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Rectangle;
import data.GSB;
import data.TextureManager;

public class AskButton {
    boolean activated = false;
    int x = 0;
    int y = 0;
    int width = TextureManager.get("askbutton_no.png").getWidth();
    int height = TextureManager.get("askbutton_no.png").getHeight();
    Rectangle yes = new Rectangle(33.0f, 9.0f, 25.0f, 24.0f);
    Rectangle no = new Rectangle(5.0f, 9.0f, 25.0f, 24.0f);

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void center(boolean x, boolean y) {
        if (x) {
            this.x -= this.width / 2;
        }
        if (y) {
            this.y -= this.height / 2;
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void update() {
        if (Gdx.input.isButtonPressed(0) && Gdx.input.justTouched()) {
            int touchedx = Gdx.input.getX();
            int touchedy = Gdx.graphics.getHeight() - Gdx.input.getY();
            if (this.yes.contains(touchedx -= this.x, touchedy -= this.y)) {
                this.setActivated(true);
            }
            if (this.no.contains(touchedx, touchedy)) {
                this.setActivated(false);
            }
        }
    }

    public void render() {
        if (this.activated) {
            GSB.hud.draw(TextureManager.get("askbutton_yes.png"), (float)this.x, (float)this.y);
        } else {
            GSB.hud.draw(TextureManager.get("askbutton_no.png"), (float)this.x, (float)this.y);
        }
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean getValue() {
        return this.activated;
    }
}

