/*
 * Decompiled with CFR 0.152.
 */
package tiles;

import data.FontManager;
import data.GSB;
import tiles.Tile;

public class OperationTile
extends Tile {
    private String operation = "+ 0";
    public boolean inversed = false;

    public OperationTile(String operation) {
        this.block = false;
        this.setOperation(operation);
    }

    @Override
    public void render() {
        super.render();
        FontManager.get(20, this.inversed ? 1 : 0).draw(GSB.sb, this.operation, this.x * 54 + 27 + 8 * this.x, this.y * 54 + 27 + 6 + 8 * this.y, 0.0f, 1, false);
    }

    public void setOperation(String operation) {
        if (this.isValid(operation)) {
            this.operation = operation;
        }
    }

    private boolean isValid(String operation) {
        String toTest = operation.replace(" ", "");
        char oper = toTest.charAt(0);
        if (oper == '+' || oper == '/' || oper == '-' || oper == 'x') {
            String numba = toTest.substring(1, operation.length());
            try {
                int n = Integer.parseInt(numba);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public void inverseOperation() {
        this.inversed = !this.inversed;
        String toTest = this.operation.replace(" ", "");
        if (!toTest.equals("x-1")) {
            char oper = toTest.charAt(0);
            oper = oper == '/' ? (char)'x' : (oper == 'x' ? (char)'/' : (oper == '+' ? (char)'-' : '+'));
            this.operation = oper + this.operation.substring(1, this.operation.length());
        }
        this.path = this.inversed ? "empty264.png" : "empty64.png";
    }

    public String getOperation() {
        return this.operation;
    }

    public int[] newValues(int numerator, int denominator) {
        String toTest = this.operation.replace(" ", "");
        char oper = toTest.charAt(0);
        int numba = Integer.parseInt(toTest.substring(1, toTest.length()));
        switch (oper) {
            case '+': {
                numerator += denominator * numba;
                break;
            }
            case '-': {
                numerator -= denominator * numba;
                break;
            }
            case 'x': {
                numerator *= numba;
                break;
            }
            case '/': {
                denominator *= numba;
                break;
            }
        }
        int[] toReturn = new int[]{numerator, denominator};
        return toReturn;
    }
}

