/*
 * Decompiled with CFR 0.152.
 */
package screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.Screen;
import data.FontManager;
import data.GSB;
import data.ScreenManager;
import data.SoundManager;
import data.SpriteManager;
import game.Constants;
import game.Map;
import game.Player;
import ui_buttons.BigButton;

public class TimeTrialView
implements Screen {
    Player player = new Player();
    public Map currentMap;
    BigButton backToMenu;
    BigButton pause;
    BigButton reset;
    BigButton resume;
    int goal;
    int score = 0;
    int total = 10;
    boolean won = false;
    boolean paused = false;
    long initial = 0L;
    long temps = 0L;

    public TimeTrialView() {
        SoundManager.get("yahoo.wav").play(0.0f);
        this.backToMenu = new BigButton("Back to menu"){

            @Override
            protected void onClick() {
                ScreenManager.setScreen("menu");
            }
        };
        this.reset = new BigButton("Reset"){

            @Override
            protected void onClick() {
                TimeTrialView.this.player.numerator = 0;
                TimeTrialView.this.player.denominator = 1;
                TimeTrialView.this.player.x = TimeTrialView.this.currentMap.spawnX;
                TimeTrialView.this.player.y = TimeTrialView.this.currentMap.spawnY;
                TimeTrialView.this.currentMap.reset();
            }
        };
        this.pause = new BigButton("||"){

            @Override
            protected void onClick() {
                TimeTrialView.this.reset.setLocation(Gdx.graphics.getWidth() / 2, Gdx.graphics.getHeight() / 2);
                TimeTrialView.this.reset.center(true, true);
                TimeTrialView.this.resume.setLocation(TimeTrialView.this.reset.getX(), TimeTrialView.this.reset.getY() + Gdx.graphics.getHeight() / 4);
                TimeTrialView.this.resume.center(false, true);
                TimeTrialView.this.backToMenu.setLocation(TimeTrialView.this.reset.getX(), TimeTrialView.this.reset.getY() - Gdx.graphics.getHeight() / 4);
                TimeTrialView.this.backToMenu.center(false, true);
                TimeTrialView.this.paused = true;
            }
        };
        this.resume = new BigButton("Resume"){

            @Override
            protected void onClick() {
                TimeTrialView.this.paused = false;
            }
        };
    }

    public void generateMap() {
        Map newCurrentMap = new Map();
        do {
            newCurrentMap.generateMap();
        } while (!newCurrentMap.isConnexe());
        newCurrentMap.spawnX = this.player.nextX;
        newCurrentMap.spawnY = this.player.nextY;
        this.setCurrentMap(newCurrentMap);
    }

    public void setCurrentMap(Map currentMap) {
        this.paused = false;
        this.currentMap = currentMap;
        this.player.setMap(currentMap);
        this.player.x = currentMap.spawnX;
        this.player.y = currentMap.spawnY;
        this.player.numerator = currentMap.init;
        this.player.denominator = 1;
        this.goal = currentMap.goal;
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.73333335f, 0.6784314f, 0.627451f, 1.0f);
        Gdx.gl.glClear(16384);
        GSB.sb.begin();
        this.currentMap.render();
        this.player.render();
        GSB.sb.end();
        GSB.hud.begin();
        FontManager.get(Constants.hudSize).draw(GSB.hud, "Time : " + this.temps / 1000L, 20.0f, Gdx.graphics.getHeight() - 5, Gdx.graphics.getWidth() - 40, 8, true);
        FontManager.get(Constants.hudSize).draw(GSB.hud, "Left : " + (this.total - this.score), 20.0f, Gdx.graphics.getHeight() - 5, Gdx.graphics.getWidth() - 40 - this.pause.getWidth(), 16, true);
        FontManager.get(Constants.hudSize).draw(GSB.hud, "Goal : " + this.goal, 20.0f, Gdx.graphics.getHeight() - 5, Gdx.graphics.getWidth() - 40, 1, true);
        this.pause.render(0);
        GSB.hud.end();
        this.pause.update();
        if (this.paused) {
            GSB.hud.begin();
            SpriteManager.get("blackPixel.png").setSize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
            SpriteManager.get("blackPixel.png").draw(GSB.hud, 0.2f);
            this.resume.render(0);
            this.reset.render(0);
            this.backToMenu.render(0);
            GSB.hud.end();
            this.resume.update();
            this.reset.update();
            this.backToMenu.update();
        }
        if (this.won) {
            GSB.hud.begin();
            int centieme = (int)(this.temps / 10L) % 100;
            FontManager.get(Constants.hudSize).draw(GSB.hud, "Temps : " + this.temps / 1000L + "." + centieme + " s", 0.0f, Gdx.graphics.getHeight() - Gdx.graphics.getHeight() / 4, Gdx.graphics.getWidth(), 1, false);
            SpriteManager.get("blackPixel.png").setSize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
            SpriteManager.get("blackPixel.png").draw(GSB.hud, 0.2f);
            this.backToMenu.render(0);
            GSB.hud.end();
            this.backToMenu.update();
        } else {
            this.temps = System.currentTimeMillis() - this.initial;
        }
        this.player.update(delta, !this.won);
        if (this.player.numerator == this.goal && this.player.denominator == 1 && !this.won) {
            ++this.score;
            if (this.score < this.total) {
                this.generateMap();
            } else {
                this.won = true;
                this.paused = false;
                this.backToMenu.setLocation(Gdx.graphics.getWidth() / 2, Gdx.graphics.getHeight() / 2);
                this.backToMenu.center(true, true);
                Preferences p = Gdx.app.getPreferences("timetrial");
                int progr = (int)this.temps;
                if (progr > p.getInteger("highscore", 0)) {
                    p.putInteger("highscore", progr);
                }
                p.flush();
            }
        }
    }

    @Override
    public void resize(int width, int height) {
        GSB.resize(width, height);
        GSB.camera.position.x = 62 * this.currentMap.width / 2;
        GSB.camera.position.y = 62 * this.currentMap.height / 2;
        float ratioW = (float)(this.currentMap.width * 62 + 20) / ((float)width + 0.0f);
        float ratioH = (float)(this.currentMap.height * 62 + 60) / ((float)height + 0.0f);
        float max = Math.max(ratioW, ratioH);
        if ((double)max < 0.8) {
            max = 0.8f;
        }
        GSB.camera.zoom = max;
        GSB.update();
        Constants.hudSize = 35;
        int width2 = width / 2;
        this.backToMenu.setSize(width2, width2 / 3);
        this.reset.setSize(this.backToMenu.getWidth(), this.backToMenu.getHeight());
        this.resume.setSize(this.backToMenu.getWidth(), this.backToMenu.getHeight());
        this.pause.setSize(Gdx.graphics.getWidth() / 10, Gdx.graphics.getWidth() / 10);
        this.pause.setLocation(width - this.pause.getWidth(), height - this.pause.getHeight());
    }

    @Override
    public void show() {
        this.generateMap();
        this.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.initial = System.currentTimeMillis();
        this.score = 0;
        this.won = false;
    }

    @Override
    public void pause() {
        System.exit(0);
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }
}

