/*
 * Decompiled with CFR 0.152.
 */
package screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.kotcrab.vis.ui.widget.VisWindow;
import data.FontManager;
import data.GSB;
import data.ScreenManager;
import game.Map;
import screens.ChallengeGameView;
import tiles.BlockTile;
import tiles.EmptyTile;
import tiles.OperationTile;
import tiles.Tile;

public class EditorView
implements Screen {
    Map m;
    Stage stage;
    final VisWindow transformer;
    final VisWindow operation;
    final VisWindow mapInfo;
    VisTextButton toBlock;
    VisTextButton toEmpty;
    public int numbaActual = 1;
    public char oper = (char)43;
    public int scrolled = 0;
    public Vector2 lastClick = new Vector2(0.0f, 0.0f);
    public Vector2 currTile = new Vector2(0.0f, 0.0f);
    Tile toSetEverywhere = new EmptyTile();

    public EditorView() {
        this.m = new Map();
        this.m.generateMap();
        if (!VisUI.isLoaded()) {
            VisUI.load();
        }
        this.stage = new Stage(){

            @Override
            public boolean scrolled(int amount) {
                EditorView.this.scrolled = amount;
                return true;
            }
        };
        this.mapInfo = new VisWindow("Map I/O");
        final VisTextField fileName = new VisTextField("filename");
        final VisTextField width = new VisTextField(this.m.width + "");
        final VisTextField height = new VisTextField(this.m.height + "");
        VisTextButton importMap = new VisTextButton("Import Map");
        VisTextButton exportMap = new VisTextButton("Export Map");
        VisTextButton setSize = new VisTextButton("Set Size");
        VisTextButton play = new VisTextButton("Play Map");
        setSize.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                int oldWidth = EditorView.this.m.width;
                int oldHeight = EditorView.this.m.height;
                try {
                    EditorView.this.m.width = Integer.parseInt(width.getText());
                    EditorView.this.m.height = Integer.parseInt(height.getText());
                }
                catch (NumberFormatException e) {
                    return;
                }
                Tile[][] newTiles = new Tile[EditorView.this.m.height][EditorView.this.m.width];
                for (int i = 0; i < EditorView.this.m.height; ++i) {
                    for (int j = 0; j < EditorView.this.m.width; ++j) {
                        if (i >= oldHeight || j >= oldWidth) {
                            EmptyTile newTile = new EmptyTile();
                            newTile.x = j;
                            newTile.y = i;
                            newTiles[i][j] = newTile;
                            continue;
                        }
                        newTiles[i][j] = EditorView.this.m.tiles[i][j];
                    }
                }
                if (EditorView.this.currTile.x >= (float)oldWidth) {
                    EditorView.this.currTile.x = oldWidth - 1;
                }
                if (EditorView.this.currTile.y >= (float)oldHeight) {
                    EditorView.this.currTile.y = oldHeight - 1;
                }
                EditorView.this.m.tiles = newTiles;
            }
        });
        importMap.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                boolean done = EditorView.this.m.importMap(fileName.getText());
                if (!done) {
                    fileName.setText("ERROR !");
                }
            }
        });
        exportMap.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                EditorView.this.m.exportMap(fileName.getText());
            }
        });
        play.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ((ChallengeGameView)ScreenManager.getScreen("game")).setCurrentMap(EditorView.this.m);
                ScreenManager.setScreen("game");
            }
        });
        this.mapInfo.add(width).uniform().left();
        this.mapInfo.row();
        this.mapInfo.add(height).uniform().left();
        this.mapInfo.row();
        this.mapInfo.add(setSize).uniform().left().padTop(5.0f);
        this.mapInfo.row();
        this.mapInfo.add(fileName).uniform().left().padTop(5.0f);
        this.mapInfo.row();
        this.mapInfo.add(importMap).uniform().left().padTop(5.0f);
        this.mapInfo.row();
        this.mapInfo.add(exportMap).uniform().left().padTop(5.0f);
        this.mapInfo.row();
        this.mapInfo.add(play).uniform().left().padTop(5.0f);
        this.mapInfo.setWidth(this.mapInfo.getPrefWidth() + 5.0f);
        this.mapInfo.setHeight(this.mapInfo.getPrefHeight() + 5.0f);
        this.operation = new VisWindow("Create Operation");
        final VisLabel result = new VisLabel("+1");
        VisTextButton plus = new VisTextButton("+");
        plus.setWidth(20.0f);
        plus.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                EditorView.this.oper = (char)43;
                if (EditorView.this.numbaActual < 0) {
                    EditorView.this.numbaActual = 1;
                }
                result.setText(EditorView.this.oper + "" + EditorView.this.numbaActual);
            }
        });
        VisTextButton moins = new VisTextButton("-");
        moins.setWidth(20.0f);
        moins.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                EditorView.this.oper = (char)45;
                if (EditorView.this.numbaActual < 0) {
                    EditorView.this.numbaActual = 1;
                }
                result.setText(EditorView.this.oper + "" + EditorView.this.numbaActual);
            }
        });
        VisTextButton fois = new VisTextButton("x");
        fois.setWidth(20.0f);
        fois.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                EditorView.this.oper = (char)120;
                result.setText(EditorView.this.oper + "" + EditorView.this.numbaActual);
            }
        });
        VisTextButton diviser = new VisTextButton("/");
        diviser.setWidth(20.0f);
        diviser.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                EditorView.this.oper = (char)47;
                if (EditorView.this.numbaActual < 0) {
                    EditorView.this.numbaActual = 1;
                }
                result.setText(EditorView.this.oper + "" + EditorView.this.numbaActual);
            }
        });
        VisTextButton increment = new VisTextButton("inc");
        increment.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ++EditorView.this.numbaActual;
                if (EditorView.this.numbaActual == 0) {
                    EditorView.this.numbaActual = 1;
                }
                if (EditorView.this.numbaActual >= 7) {
                    EditorView.this.numbaActual = 6;
                }
                result.setText(EditorView.this.oper + "" + EditorView.this.numbaActual);
            }
        });
        VisTextButton decrement = new VisTextButton("dec");
        decrement.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                --EditorView.this.numbaActual;
                if (EditorView.this.numbaActual == 0) {
                    EditorView.this.numbaActual = EditorView.this.oper == '+' || EditorView.this.oper == '/' || EditorView.this.oper == '-' ? 1 : -1;
                }
                if (EditorView.this.numbaActual < -1) {
                    EditorView.this.numbaActual = -1;
                }
                result.setText(EditorView.this.oper + "" + EditorView.this.numbaActual);
            }
        });
        this.operation.add(plus).width(30.0f).uniform();
        this.operation.add(moins).uniform();
        this.operation.add(fois).uniform();
        this.operation.add(diviser).uniform();
        this.operation.row();
        this.operation.add(increment).colspan(2).padTop(5.0f);
        this.operation.add(decrement).colspan(2);
        this.operation.row();
        this.operation.add(result).colspan(4).padTop(5.0f);
        this.operation.setPosition(300.0f, 100.0f);
        this.transformer = new VisWindow("Transform Block", true);
        this.toBlock = new VisTextButton("To Block (B)");
        this.toEmpty = new VisTextButton("To Empty (E)");
        VisTextButton toOperation = new VisTextButton("To Operation");
        VisTextButton setSpawn = new VisTextButton("Set Spawn");
        this.toBlock.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                BlockTile b = new BlockTile();
                b.x = (int)EditorView.this.currTile.x;
                b.y = (int)EditorView.this.currTile.y;
                EditorView.this.m.tiles[(int)EditorView.this.currTile.y][(int)EditorView.this.currTile.x] = b;
                EditorView.this.toSetEverywhere = new BlockTile();
            }
        });
        this.toEmpty.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                EmptyTile et = new EmptyTile();
                et.x = (int)EditorView.this.currTile.x;
                et.y = (int)EditorView.this.currTile.y;
                EditorView.this.m.tiles[(int)EditorView.this.currTile.y][(int)EditorView.this.currTile.x] = et;
                EditorView.this.toSetEverywhere = new EmptyTile();
            }
        });
        toOperation.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                OperationTile op = new OperationTile(result.getText().toString());
                op.x = (int)EditorView.this.currTile.x;
                op.y = (int)EditorView.this.currTile.y;
                EditorView.this.m.tiles[(int)EditorView.this.currTile.y][(int)EditorView.this.currTile.x] = op;
            }
        });
        setSpawn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                EditorView.this.m.spawnX = (int)EditorView.this.currTile.x;
                EditorView.this.m.spawnY = (int)EditorView.this.currTile.y;
            }
        });
        this.transformer.add(this.toBlock).uniform().pad(5.0f).left();
        this.transformer.row();
        this.transformer.add(this.toEmpty).uniform().pad(5.0f).left();
        this.transformer.row();
        this.transformer.add(toOperation).uniform().pad(5.0f).left();
        this.transformer.row();
        this.transformer.add(setSpawn).uniform().pad(5.0f).left();
        this.transformer.setColor(Color.GRAY);
        this.transformer.setTransform(true);
        this.transformer.setPosition(70.0f, 300.0f);
        this.transformer.setWidth(this.transformer.getPrefWidth() + 10.0f);
        this.transformer.setHeight(this.transformer.getPrefHeight());
        this.stage.addActor(this.transformer);
        this.stage.addActor(this.operation);
        this.stage.addActor(this.mapInfo);
        Gdx.input.setInputProcessor(this.stage);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.73333335f, 0.6784314f, 0.627451f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.act(delta);
        if (this.scrolled != 0) {
            GSB.camera.zoom = this.scrolled > 0 ? (float)((double)GSB.camera.zoom * 1.15) : (float)((double)GSB.camera.zoom / 1.15);
            GSB.update();
            this.scrolled = 0;
        }
        if (Gdx.input.justTouched() && Gdx.input.isButtonPressed(0)) {
            Rectangle r = new Rectangle(this.transformer.getX(), this.transformer.getY(), this.transformer.getWidth(), this.transformer.getHeight());
            Rectangle r2 = new Rectangle(this.operation.getX(), this.operation.getY(), this.operation.getWidth(), this.operation.getHeight());
            Rectangle r3 = new Rectangle(this.mapInfo.getX(), this.mapInfo.getY(), this.mapInfo.getWidth(), this.mapInfo.getHeight());
            if (!(r.contains(Gdx.input.getX(), Gdx.graphics.getHeight() - Gdx.input.getY()) || r2.contains(Gdx.input.getX(), Gdx.graphics.getHeight() - Gdx.input.getY()) || r3.contains(Gdx.input.getX(), Gdx.graphics.getHeight() - Gdx.input.getY()))) {
                Vector3 unprojected = GSB.camera.unproject(new Vector3(Gdx.input.getX(), Gdx.input.getY(), 0.0f));
                int x = -1;
                int y = -1;
                if (unprojected.x > 0.0f) {
                    x = (int)unprojected.x / 62;
                }
                if (unprojected.y > 0.0f) {
                    y = (int)unprojected.y / 62;
                }
                System.out.println(x + " " + y);
                if (x >= 0 && x < this.m.width && y >= 0 && y < this.m.height) {
                    this.currTile = new Vector2(x, y);
                }
            }
        }
        if (Gdx.input.isButtonPressed(1) && !Gdx.input.justTouched()) {
            GSB.camera.translate((this.lastClick.x - (float)Gdx.input.getX()) * GSB.camera.zoom, 0.0f);
            this.lastClick.x = Gdx.input.getX();
            GSB.camera.translate(0.0f, ((float)Gdx.input.getY() - this.lastClick.y) * GSB.camera.zoom);
            this.lastClick.y = Gdx.input.getY();
            GSB.update();
        }
        if (Gdx.input.isButtonPressed(1) && Gdx.input.justTouched()) {
            this.lastClick.x = Gdx.input.getX();
            this.lastClick.y = Gdx.input.getY();
        }
        if (Gdx.input.isKeyJustPressed(30)) {
            this.toBlock.fire(new ChangeListener.ChangeEvent());
        }
        if (Gdx.input.isKeyJustPressed(33)) {
            this.toEmpty.fire(new ChangeListener.ChangeEvent());
        }
        if (Gdx.input.isKeyJustPressed(34)) {
            for (int i = 0; i < this.m.width; ++i) {
                for (int j = 0; j < this.m.height; ++j) {
                    Tile t = new BlockTile();
                    if (this.toSetEverywhere instanceof EmptyTile) {
                        t = new EmptyTile();
                    }
                    t.x = i;
                    t.y = j;
                    this.m.tiles[j][i] = t;
                }
            }
        }
        GSB.srCam.begin(ShapeRenderer.ShapeType.Filled);
        GSB.srCam.setColor(0.8f, 0.3f, 0.3f, 0.1f);
        GSB.srCam.rect(this.currTile.x * 62.0f, this.currTile.y * 62.0f, 54.0f, 54.0f);
        GSB.srCam.end();
        GSB.sb.begin();
        this.m.render();
        FontManager.get(8).draw((Batch)GSB.sb, "spawn", (float)(this.m.spawnX * 62), (float)(this.m.spawnY * 62 + 10));
        GSB.sb.end();
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        GSB.resize(width, height);
        this.stage = new Stage(){

            @Override
            public boolean scrolled(int amount) {
                EditorView.this.scrolled = amount;
                return true;
            }
        };
        this.stage.addActor(this.transformer);
        this.stage.addActor(this.operation);
        this.stage.addActor(this.mapInfo);
        Gdx.input.setInputProcessor(this.stage);
    }

    @Override
    public void show() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }
}

