/*
 * Decompiled with CFR 0.152.
 */
package screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import data.FontManager;
import data.GSB;
import data.ScreenManager;
import game.Constants;
import ui_buttons.BigButton;

public class CreditsView
implements Screen {
    BigButton backToMenu;
    GlyphLayout credits = new GlyphLayout(FontManager.get(Constants.hudSize + 5), "Credits");

    public CreditsView() {
        this.backToMenu = new BigButton("Back to menu"){

            @Override
            protected void onClick() {
                ScreenManager.setScreen("menu");
            }
        };
        this.backToMenu.setLocation(0, 0);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.73333335f, 0.6784314f, 0.627451f, 1.0f);
        Gdx.gl.glClear(16384);
        GSB.hud.begin();
        FontManager.get(Constants.hudSize + 5).draw((Batch)GSB.hud, "Credits", (float)(Gdx.graphics.getWidth() / 2) - this.credits.width / 2.0f, (float)Gdx.graphics.getHeight() - this.credits.height - 10.0f);
        FontManager.get(Constants.hudSize).draw((Batch)GSB.hud, "Uriopass : Game developer", 80.0f, (float)(2 * Gdx.graphics.getHeight() / 3));
        FontManager.get(Constants.hudSize).draw((Batch)GSB.hud, "Tagazoul : Level designer", 80.0f, (float)(Gdx.graphics.getHeight() / 3));
        this.backToMenu.render(0);
        GSB.hud.end();
        this.backToMenu.update();
    }

    @Override
    public void show() {
        this.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    @Override
    public void resize(int width, int height) {
        GSB.resize(width, height);
        this.backToMenu.setSize(width, 2 * width / 10);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }
}

