/*
 * Decompiled with CFR 0.152.
 */
package screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.Screen;
import data.GSB;
import data.ScreenManager;
import game.Constants;
import game.Map;
import screens.ChallengeGameView;
import ui_buttons.BigButton;

public class ChallengesListView
implements Screen {
    BigButton[] list = new BigButton[this.size];
    int size = 12;
    public static int progress = 0;
    public static int current = 0;
    BigButton backToMenu;

    public ChallengesListView() {
        for (int i = 0; i < this.size; ++i) {
            final int finalI = i;
            BigButton cur = new BigButton("" + finalI){

                @Override
                protected void onClick() {
                    if (finalI > progress) {
                        return;
                    }
                    Map toImport = new Map();
                    if (toImport.importMap("map" + finalI + ".nbm")) {
                        current = finalI;
                        ((ChallengeGameView)ScreenManager.getScreen("game")).setCurrentMap(toImport);
                        ScreenManager.setScreen("game");
                    }
                }
            };
            cur.setMainPath("square");
            cur.setSize(100, 100);
            this.list[i] = cur;
        }
        this.backToMenu = new BigButton("Back to menu"){

            @Override
            protected void onClick() {
                ScreenManager.setScreen("menu");
            }
        };
        this.backToMenu.setLocation(0, 0);
        this.arrangePosition(800, 600);
    }

    public void arrangePosition(int width, int height) {
        int newProg;
        Preferences p = Gdx.app.getPreferences("challenge");
        progress = newProg = p.getInteger("progress");
        this.backToMenu.setSize(width, width * 2 / 10);
        int offset = 20;
        int maxX = (width -= offset * 2) / 115;
        float sizeOfCell = (float)width / (float)maxX;
        for (int i = 0; i < this.size; ++i) {
            BigButton cur = this.list[i];
            if (i > progress) {
                cur.setMainPath("squaregrey");
            } else {
                cur.setMainPath("square");
            }
            cur.setFontSize((int)((float)Constants.hudSize * 1.2f));
            float x = (float)offset + sizeOfCell * (float)(i % maxX) + sizeOfCell / 2.0f;
            int y = offset + i / maxX * 130;
            y = height - y - 100;
            cur.setLocation((int)x, y);
            cur.center(true, false);
        }
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.73333335f, 0.6784314f, 0.627451f, 1.0f);
        Gdx.gl.glClear(16384);
        GSB.hud.begin();
        for (BigButton b : this.list) {
            b.render(0);
        }
        this.backToMenu.render(0);
        GSB.hud.end();
        for (BigButton b : this.list) {
            b.update();
        }
        this.backToMenu.update();
    }

    @Override
    public void resize(int width, int height) {
        this.arrangePosition(width, height);
        GSB.resize(width, height);
    }

    @Override
    public void show() {
        this.arrangePosition(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }
}

