/*
 * Decompiled with CFR 0.152.
 */
package screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import data.FontManager;
import data.GSB;
import data.ScreenManager;
import data.SoundManager;
import data.SpriteManager;
import game.Constants;
import game.Map;
import game.Player;
import screens.ChallengesListView;
import ui_buttons.BigButton;

public class ChallengeGameView
implements Screen {
    Player player = new Player();
    public Map currentMap;
    BigButton next;
    BigButton backToMenu;
    BigButton pause;
    BigButton reset;
    BigButton resume;
    int goal;
    boolean won = false;
    boolean paused = false;

    public ChallengeGameView() {
        SoundManager.get("yahoo.wav").play(0.0f);
        GSB.init();
        this.currentMap = new Map();
        do {
            this.currentMap.generateMap();
        } while (!this.currentMap.isConnexe());
        this.goal = this.currentMap.goal;
        FontManager.setDefaultColor(new Color(0.46666667f, 0.43137255f, 0.39607844f, 1.0f));
        FontManager.get(20, 1).setColor(Color.BLUE);
        this.next = new BigButton("Next"){

            @Override
            protected void onClick() {
                Map toImport = new Map();
                if (toImport.importMap("map" + ChallengesListView.current + ".nbm")) {
                    ((ChallengeGameView)ScreenManager.getScreen("game")).setCurrentMap(toImport);
                    ScreenManager.setScreen("game");
                } else {
                    System.out.println("Error loading map");
                }
            }
        };
        this.backToMenu = new BigButton("Back to menu"){

            @Override
            protected void onClick() {
                ScreenManager.setScreen("challenges");
            }
        };
        this.reset = new BigButton("Reset"){

            @Override
            protected void onClick() {
                ChallengeGameView.this.player.numerator = ChallengeGameView.this.currentMap.init;
                ChallengeGameView.this.player.denominator = 1;
                ChallengeGameView.this.player.x = ChallengeGameView.this.currentMap.spawnX;
                ChallengeGameView.this.player.y = ChallengeGameView.this.currentMap.spawnY;
                ChallengeGameView.this.currentMap.reset();
            }
        };
        this.pause = new BigButton("||"){

            @Override
            protected void onClick() {
                ChallengeGameView.this.reset.setLocation(Gdx.graphics.getWidth() / 2, Gdx.graphics.getHeight() / 2);
                ChallengeGameView.this.reset.center(true, true);
                ChallengeGameView.this.resume.setLocation(ChallengeGameView.this.reset.getX(), ChallengeGameView.this.reset.getY() + Gdx.graphics.getHeight() / 4);
                ChallengeGameView.this.resume.center(false, true);
                ChallengeGameView.this.backToMenu.setLocation(ChallengeGameView.this.reset.getX(), ChallengeGameView.this.reset.getY() - Gdx.graphics.getHeight() / 4);
                ChallengeGameView.this.backToMenu.center(false, true);
                ChallengeGameView.this.paused = true;
            }
        };
        this.resume = new BigButton("Resume"){

            @Override
            protected void onClick() {
                ChallengeGameView.this.paused = false;
            }
        };
    }

    public void setCurrentMap(Map currentMap) {
        this.won = false;
        this.paused = false;
        this.currentMap = currentMap;
        this.player.setMap(currentMap);
        this.player.x = currentMap.spawnX;
        this.player.y = currentMap.spawnY;
        this.player.numerator = currentMap.init;
        this.player.denominator = 1;
        this.goal = currentMap.goal;
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.73333335f, 0.6784314f, 0.627451f, 1.0f);
        Gdx.gl.glClear(16384);
        GSB.sb.begin();
        this.currentMap.render();
        this.player.render();
        GSB.sb.end();
        GSB.hud.begin();
        FontManager.get(Constants.hudSize).draw(GSB.hud, "But : " + this.goal, 20.0f, Gdx.graphics.getHeight() - 5, Gdx.graphics.getWidth() - 40, 1, true);
        this.pause.render(0);
        GSB.hud.end();
        this.pause.update();
        if (this.paused) {
            GSB.hud.begin();
            SpriteManager.get("blackPixel.png").setSize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
            SpriteManager.get("blackPixel.png").draw(GSB.hud, 0.2f);
            this.resume.render(0);
            this.reset.render(0);
            this.backToMenu.render(0);
            GSB.hud.end();
            this.resume.update();
            this.reset.update();
            this.backToMenu.update();
        }
        if (this.won) {
            GSB.hud.begin();
            SpriteManager.get("blackPixel.png").setSize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
            SpriteManager.get("blackPixel.png").draw(GSB.hud, 0.2f);
            this.next.render(0);
            this.backToMenu.render(0);
            GSB.hud.end();
            this.next.update();
            this.backToMenu.update();
        }
        this.player.update(delta, !this.won);
        if (this.player.numerator == this.goal && this.player.denominator == 1 && !this.won) {
            this.won = true;
            this.paused = false;
            this.next.setLocation(Gdx.graphics.getWidth() / 2, 2 * Gdx.graphics.getHeight() / 3);
            this.next.center(true, true);
            this.backToMenu.setLocation(this.next.getX(), this.next.getY() - Gdx.graphics.getHeight() / 3);
            this.backToMenu.center(false, true);
            if (++ChallengesListView.current > ChallengesListView.progress) {
                ChallengesListView.progress = ChallengesListView.current;
            }
            Preferences p = Gdx.app.getPreferences("challenge");
            int progr = ChallengesListView.progress;
            p.putInteger("progress", progr);
            p.flush();
        }
    }

    @Override
    public void resize(int width, int height) {
        GSB.resize(width, height);
        GSB.camera.position.x = 62 * this.currentMap.width / 2;
        GSB.camera.position.y = 62 * this.currentMap.height / 2;
        float ratioW = (float)(this.currentMap.width * 62 + 20) / ((float)width + 0.0f);
        float ratioH = (float)(this.currentMap.height * 62 + 60) / ((float)height + 0.0f);
        float max = Math.max(ratioW, ratioH);
        if ((double)max < 0.8) {
            max = 0.8f;
        }
        GSB.camera.zoom = max;
        GSB.update();
        System.out.println(width);
        Constants.hudSize = 35;
        int width2 = width / 2;
        this.next.setSize(width2, width2 / 3);
        this.backToMenu.setSize(this.next.getWidth(), this.next.getHeight());
        this.reset.setSize(this.next.getWidth(), this.next.getHeight());
        this.resume.setSize(this.next.getWidth(), this.next.getHeight());
        this.pause.setSize(Gdx.graphics.getWidth() / 10, Gdx.graphics.getWidth() / 10);
        this.pause.setLocation(width - this.pause.getWidth(), height - this.pause.getHeight());
    }

    @Override
    public void show() {
        this.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    @Override
    public void pause() {
        System.exit(0);
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }
}

