/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import data.Vector2d;
import game.SwapType;

public class SwapperChecker {
    SwapType lastSwap = SwapType.NONE;
    boolean returned = true;
    Vector2d lastClicked = null;
    boolean updateTouch = false;
    boolean alreadyMoved = false;
    Sound s;

    public void update() {
        if (Gdx.input.isKeyJustPressed(20)) {
            this.returned = false;
            this.lastSwap = SwapType.DOWN;
        }
        if (Gdx.input.isKeyJustPressed(19)) {
            this.returned = false;
            this.lastSwap = SwapType.UP;
        }
        if (Gdx.input.isKeyJustPressed(21)) {
            this.returned = false;
            this.lastSwap = SwapType.LEFT;
        }
        if (Gdx.input.isKeyJustPressed(22)) {
            this.returned = false;
            this.lastSwap = SwapType.RIGHT;
        }
        if (Gdx.input.isTouched()) {
            Vector2d swipVector;
            if (!this.updateTouch) {
                if (this.lastClicked == null) {
                    this.lastClicked = new Vector2d(0.0, 0.0);
                }
                this.lastClicked.x = Gdx.input.getX();
                this.lastClicked.y = Gdx.graphics.getHeight() - Gdx.input.getY();
                this.updateTouch = true;
                this.alreadyMoved = false;
            }
            if (this.updateTouch && !this.alreadyMoved && (swipVector = new Vector2d((double)Gdx.input.getX() - this.lastClicked.x, (double)(Gdx.graphics.getHeight() - Gdx.input.getY()) - this.lastClicked.y)).length() > 30.0) {
                this.alreadyMoved = true;
                double angle = swipVector.angle(Vector2d.basic);
                if (this.between(angle, -0.7853981633974483, 0.7853981633974483)) {
                    this.lastSwap = SwapType.RIGHT;
                    this.returned = false;
                }
                if (this.between(angle, 2.356194490192345, Math.PI) || this.between(angle, -Math.PI, -2.356194490192345)) {
                    this.lastSwap = SwapType.LEFT;
                    this.returned = false;
                }
                if (this.between(angle, 0.7853981633974483, 2.356194490192345)) {
                    this.lastSwap = SwapType.UP;
                    this.returned = false;
                }
                if (this.between(angle, -2.356194490192345, -0.7853981633974483)) {
                    this.lastSwap = SwapType.DOWN;
                    this.returned = false;
                }
            }
        } else {
            this.updateTouch = false;
        }
    }

    boolean between(double angle, double low, double high) {
        return angle >= low && angle <= high;
    }

    public Vector2d getLastClicked() {
        return this.lastClicked;
    }

    public boolean hasSwap() {
        return !this.returned;
    }

    public SwapType getSwap() {
        if (!this.hasSwap()) {
            return SwapType.NONE;
        }
        this.returned = true;
        return this.lastSwap;
    }
}

