/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import data.FontManager;
import data.GSB;
import data.SoundManager;
import data.SpriteManager;
import game.Map;
import game.SwapType;
import game.SwapperChecker;
import tiles.OperationTile;
import tiles.Tile;

public class Player {
    public int numerator = 0;
    public int denominator = 1;
    public int x = 0;
    public int y = 0;
    public int nextX = 0;
    public int nextY = 0;
    public int averageX = 0;
    public int averageY = 0;
    boolean inAnimation = false;
    boolean changedDone = false;
    float animationTime = 0.22500001f;
    float animationProgression = 0.2f;
    int[] toChange;
    BitmapFont bigFont;
    BitmapFont smallFont;
    BitmapFont useFont;
    Map map;
    SwapperChecker swapperChecker = new SwapperChecker();

    public Player() {
        this.smallFont = FontManager.getInstance(12);
        this.smallFont.setColor(Color.RED);
        this.bigFont = FontManager.getInstance(17);
        this.bigFont.setColor(Color.RED);
        this.useFont = this.bigFont;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    private void goTo(int gotox, int gotoy) {
        SoundManager.get("yahoo.wav").play();
        this.nextX = gotox;
        this.nextY = gotoy;
        this.averageX = (gotox + this.x) / 2;
        this.averageY = (gotoy + this.y) / 2;
        Tile tile = this.map.tiles[this.averageY][this.averageX];
        this.toChange = new int[2];
        if (tile instanceof OperationTile) {
            this.toChange = ((OperationTile)tile).newValues(this.numerator, this.denominator);
        } else {
            this.toChange[0] = this.numerator;
            this.toChange[1] = this.denominator;
        }
        this.inAnimation = true;
    }

    private void doTheChanges() {
        if (this.map.tiles[this.averageY][this.averageX] instanceof OperationTile) {
            ((OperationTile)this.map.tiles[this.averageY][this.averageX]).inverseOperation();
            this.numerator = this.toChange[0];
            this.denominator = this.toChange[1];
            this.simplify();
            this.changedDone = true;
            this.useFont = this.denominator == 1 ? this.bigFont : this.smallFont;
        }
    }

    public void update(float delta, boolean updateInput) {
        this.swapperChecker.update();
        SwapType st = this.swapperChecker.getSwap();
        if (this.inAnimation) {
            this.animationProgression += delta / this.animationTime;
            if (this.animationProgression > 0.5f && !this.changedDone) {
                this.doTheChanges();
            }
            if (this.animationProgression >= 1.0f) {
                this.inAnimation = false;
                this.changedDone = false;
                this.animationProgression = 0.2f;
                this.x = this.nextX;
                this.y = this.nextY;
            }
        }
        if (!this.inAnimation && updateInput) {
            if (st.equals((Object)SwapType.LEFT) && this.x - 2 >= 0 && !this.map.isBlocked(this.x - 2, this.y) && !this.map.isBlocked(this.x - 1, this.y)) {
                this.goTo(this.x - 2, this.y);
            }
            if (st.equals((Object)SwapType.RIGHT) && this.x < this.map.width - 2 && !this.map.isBlocked(this.x + 2, this.y) && !this.map.isBlocked(this.x + 1, this.y)) {
                this.goTo(this.x + 2, this.y);
            }
            if (st.equals((Object)SwapType.UP) && this.y < this.map.height - 2 && !this.map.isBlocked(this.x, this.y + 2) && !this.map.isBlocked(this.x, this.y + 1)) {
                this.goTo(this.x, this.y + 2);
            }
            if (st.equals((Object)SwapType.DOWN) && this.y - 2 >= 0 && !this.map.isBlocked(this.x, this.y - 2) && !this.map.isBlocked(this.x, this.y - 1)) {
                this.goTo(this.x, this.y - 2);
            }
        }
    }

    private void simplify() {
        boolean sign;
        boolean bl = sign = this.numerator < 0;
        if (sign) {
            this.numerator *= -1;
        }
        int a = Math.max(this.denominator, this.numerator);
        int b = Math.min(this.numerator, this.denominator);
        if (b == 1) {
            if (sign) {
                this.numerator *= -1;
            }
            return;
        }
        while (b != 0) {
            int tmp = a %= b;
            a = b;
            b = tmp;
        }
        this.numerator /= a;
        this.denominator /= a;
        if (sign) {
            this.numerator *= -1;
        }
    }

    public void render() {
        float renderX = this.x * 54 + 27 + 8 * this.x;
        float renderY = this.y * 54 + 27 + (this.useFont == this.bigFont ? 5 : 3) + 8 * this.y;
        float offsetY = 0.0f;
        float offsetX = 0.0f;
        if (this.inAnimation) {
            offsetX = this.animationProgression * (float)(this.nextX - this.x) * 62.0f;
            offsetY = this.animationProgression * (float)(this.nextY - this.y) * 62.0f;
        }
        if (this.denominator == 1) {
            SpriteManager.get("player64.png").setBounds((float)(this.x * 62) + offsetX, (float)(this.y * 62) + offsetY, 54.0f, 54.0f);
            SpriteManager.get("player64.png").draw(GSB.sb);
            this.bigFont.draw(GSB.sb, "" + this.numerator, renderX + offsetX, renderY + offsetY, 0.0f, 1, false);
        } else {
            SpriteManager.get("player642.png").setBounds((float)(this.x * 62) + offsetX, (float)(this.y * 62) + offsetY, 54.0f, 54.0f);
            SpriteManager.get("player642.png").draw(GSB.sb);
            this.bigFont.draw(GSB.sb, "" + this.numerator, renderX + offsetX, renderY + offsetY + 15.0f, 0.0f, 1, false);
            this.bigFont.draw(GSB.sb, "" + this.denominator, renderX + offsetX, renderY + offsetY - 12.0f, 0.0f, 1, false);
        }
    }
}

