/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Random;
import java.util.Scanner;
import tiles.BlockTile;
import tiles.EmptyTile;
import tiles.OperationTile;
import tiles.Tile;

public class Map {
    public int width = 9;
    public int height = 9;
    public int spawnX = 0;
    public int spawnY = 0;
    public int goal = 10;
    public int init = 0;
    public Tile[][] tiles = new Tile[this.height][this.width];
    public Random random = new Random(System.currentTimeMillis());

    public boolean importMap(String path) {
        FileHandle fh = Gdx.files.internal(path);
        if (!fh.exists()) {
            return false;
        }
        Scanner sc = new Scanner(fh.read());
        this.width = sc.nextInt();
        this.height = sc.nextInt();
        this.spawnX = sc.nextInt();
        this.spawnY = sc.nextInt();
        this.goal = sc.nextInt();
        this.init = sc.nextInt();
        sc.nextLine();
        this.tiles = new Tile[this.height][this.width];
        for (int i = 0; i < this.height; ++i) {
            String line = sc.nextLine();
            String[] splitted = line.split(",");
            try {
                for (int j = 0; j < this.width; ++j) {
                    String actual = splitted[j].trim();
                    if (actual.equals("B")) {
                        BlockTile b = new BlockTile();
                        b.x = j;
                        b.y = i;
                        this.tiles[i][j] = b;
                        continue;
                    }
                    if (actual.equals("E")) {
                        EmptyTile e = new EmptyTile();
                        e.x = j;
                        e.y = i;
                        this.tiles[i][j] = e;
                        continue;
                    }
                    OperationTile operationTile = new OperationTile(actual);
                    operationTile.x = j;
                    operationTile.y = i;
                    this.tiles[i][j] = operationTile;
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return false;
            }
        }
        return true;
    }

    public void exportMap(String path) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new File(Gdx.files.internal(path).path()));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        pw.write(this.width + " " + this.height + " " + this.spawnX + " " + this.spawnY + " " + this.goal + " " + this.init + "\n");
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                if (this.tiles[i][j] instanceof BlockTile) {
                    pw.write("B, ");
                }
                if (this.tiles[i][j] instanceof EmptyTile) {
                    pw.write("E, ");
                }
                if (!(this.tiles[i][j] instanceof OperationTile)) continue;
                pw.write(((OperationTile)this.tiles[i][j]).getOperation() + ", ");
            }
            pw.write("\n");
        }
        pw.flush();
    }

    public void generateMap() {
        this.init = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                Tile tile;
                boolean oddy;
                boolean oddx = j % 2 == 1;
                boolean bl = oddy = i % 2 == 1;
                if (oddx && oddy) {
                    tile = new BlockTile();
                } else if (!oddx && !oddy) {
                    tile = new EmptyTile();
                } else if ((double)this.random.nextFloat() > 0.15) {
                    char[] opers = new char[]{'+', '-', '+', '-', '/', 'x', 'o'};
                    char oper = opers[this.random.nextInt(opers.length)];
                    if (oper == 'o') {
                        tile = new OperationTile("x-1");
                    } else {
                        int number = this.random.nextInt(5) + 1;
                        if (oper == '/' || oper == 'x') {
                            ++number;
                        }
                        tile = new OperationTile(oper + "" + number);
                    }
                } else {
                    tile = new BlockTile();
                }
                tile.y = i;
                tile.x = j;
                this.tiles[i][j] = tile;
            }
        }
        this.goal = this.random.nextInt(28) + 2;
        if (this.random.nextFloat() > 0.5f) {
            this.goal *= -1;
            this.goal /= 2;
        }
    }

    public boolean isConnexe() {
        int j;
        int i;
        int[][] connexeTest = new int[(this.height + 1) / 2][(this.width + 1) / 2];
        for (i = 0; i < connexeTest.length; ++i) {
            for (j = 0; j < connexeTest[i].length; ++j) {
                connexeTest[i][j] = 0;
                if (i != 0 || j != 0) continue;
                connexeTest[i][j] = 1;
            }
        }
        for (int k = 0; k < connexeTest.length * connexeTest[0].length + 3; ++k) {
            boolean breakOrNot = true;
            for (int i2 = 0; i2 < connexeTest.length; ++i2) {
                for (int j2 = 0; j2 < connexeTest[i2].length; ++j2) {
                    boolean up;
                    if (connexeTest[i2][j2] != 1) continue;
                    boolean down = i2 > 0;
                    boolean left = j2 > 0;
                    boolean right = j2 < connexeTest[0].length - 1;
                    boolean bl = up = i2 < connexeTest.length - 1;
                    if (down && !this.isBlocked(j2 * 2, i2 * 2 - 1) && connexeTest[i2 - 1][j2] == 0) {
                        connexeTest[i2 - 1][j2] = 1;
                        breakOrNot = false;
                    }
                    if (up && !this.isBlocked(j2 * 2, i2 * 2 + 1) && connexeTest[i2 + 1][j2] == 0) {
                        connexeTest[i2 + 1][j2] = 1;
                        breakOrNot = false;
                    }
                    if (left && !this.isBlocked(j2 * 2 - 1, i2 * 2) && connexeTest[i2][j2 - 1] == 0) {
                        connexeTest[i2][j2 - 1] = 1;
                        breakOrNot = false;
                    }
                    if (right && !this.isBlocked(j2 * 2 + 1, i2 * 2) && connexeTest[i2][j2 + 1] == 0) {
                        connexeTest[i2][j2 + 1] = 1;
                        breakOrNot = false;
                    }
                    connexeTest[i2][j2] = 2;
                }
            }
            if (breakOrNot) break;
        }
        for (i = 0; i < connexeTest.length; ++i) {
            for (j = 0; j < connexeTest[i].length; ++j) {
                if (connexeTest[i][j] != 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isBlocked(int x, int y) {
        return this.tiles[y][x].block;
    }

    public void render() {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.tiles[i][j].render();
            }
        }
    }

    public void reset() {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                if (!(this.tiles[i][j] instanceof OperationTile)) continue;
                OperationTile t = (OperationTile)this.tiles[i][j];
                if (!t.inversed) continue;
                t.inverseOperation();
            }
        }
    }
}

