/*
 * Decompiled with CFR 0.152.
 */
package data;

import com.badlogic.gdx.math.Vector3;

public class Vector2d {
    public static Vector2d zero = new Vector2d(0.0, 0.0);
    public static Vector2d basic = new Vector2d(1.0, 0.0);
    public double x;
    public double y;
    Vector3 trans;

    public Vector2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2d(Vector2d v) {
        this.x = v.x;
        this.y = v.y;
    }

    public void add(double x, double y) {
        this.x += x;
        this.y += y;
    }

    public void add(Vector2d v) {
        this.add(v.x, v.y);
    }

    public void mul(double scalar) {
        this.x *= scalar;
        this.y *= scalar;
    }

    public Vector3 vec() {
        if (this.trans == null) {
            this.trans = new Vector3(0.0f, 0.0f, 0.0f);
        }
        if ((double)this.trans.x == this.x && (double)this.trans.y == this.y) {
            return this.trans;
        }
        this.trans.x = (float)this.x;
        this.trans.y = (float)this.y;
        return this.trans;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public void dec(Vector2d v) {
        this.x -= v.x;
        this.y -= v.y;
    }

    public void dec(double x, double y) {
        this.x -= x;
        this.y -= y;
    }

    public double crs(Vector2d v) {
        return this.x * v.y - this.y * v.x;
    }

    public double dot(Vector2d v) {
        return this.x * v.x + this.y * v.y;
    }

    public double angle(Vector2d reference) {
        return -Math.atan2(this.crs(reference), this.dot(reference));
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public double length2() {
        return this.x * this.x + this.y * this.y;
    }

    public double distanceTo(Vector2d v) {
        double x = this.x - v.x;
        double y = this.y - v.y;
        return Math.sqrt(x * x + y * y);
    }

    public double distanceTo(double x, double y) {
        double x2 = this.x - x;
        double y2 = this.y - y;
        return Math.sqrt(x2 * x2 + y2 * y2);
    }

    public void nor() {
        double length = this.length();
        if (length == 0.0) {
            return;
        }
        this.x /= length;
        this.y /= length;
    }

    public void set(Vector2d v) {
        this.x = v.x;
        this.y = v.y;
    }

    public void set(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2d copy() {
        return new Vector2d(this);
    }

    public void ortho() {
        double tmp = this.x;
        this.x = -this.y;
        this.y = tmp;
    }
}

