/*
 * Decompiled with CFR 0.152.
 */
package data;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import data.FontManager;
import data.SoundManager;
import data.SpriteManager;
import data.TextureManager;
import java.util.HashMap;
import screens.ChallengeGameView;
import screens.ChallengesListView;
import screens.CreditsView;
import screens.EditorView;
import screens.MenuView;
import screens.TimeTrialView;

public class ScreenManager
implements Screen {
    public static HashMap<String, Screen> screens = new HashMap();
    static Screen currScreen;
    public static String firstScreen;
    public static boolean paused;
    boolean once = true;

    public static void setStringToScreen(String s, Screen scr) {
        screens.put(s, scr);
        currScreen = scr;
    }

    public static void setScreen(String screen) {
        if (firstScreen.equals("")) {
            firstScreen = screen;
        }
        if ((currScreen = screens.get(screen)) == null) {
            throw new RuntimeException("No screen with name " + screen);
        }
        currScreen.show();
    }

    public static Screen getScreen(String screen) {
        return screens.get(screen);
    }

    @Override
    public void show() {
        currScreen.show();
    }

    @Override
    public void render(float delta) {
        if (paused || Gdx.app.getPreferences("pause").getBoolean("p", false)) {
            paused = false;
            Gdx.app.getPreferences("pause").putBoolean("p", false);
            this.resume();
        }
        currScreen.render(delta);
    }

    @Override
    public void resize(int width, int height) {
        currScreen.resize(width, height);
    }

    @Override
    public void pause() {
        paused = true;
        System.out.println("Paused !");
        Gdx.app.getPreferences("pause").putBoolean("p", true);
        Gdx.app.getPreferences("pause").flush();
    }

    @Override
    public void resume() {
        if (this.once) {
            TextureManager.reload();
            FontManager.reload();
            SpriteManager.reload();
            SoundManager.reload();
            ScreenManager.setStringToScreen("game", new ChallengeGameView());
            ScreenManager.setStringToScreen("editor", new EditorView());
            ScreenManager.setStringToScreen("menu", new MenuView());
            ScreenManager.setStringToScreen("challenges", new ChallengesListView());
            ScreenManager.setStringToScreen("credits", new CreditsView());
            ScreenManager.setStringToScreen("timetrial", new TimeTrialView());
            ScreenManager.setScreen("menu");
            if (Gdx.app.getType() == Application.ApplicationType.Desktop) {
                this.once = false;
            }
        }
    }

    @Override
    public void hide() {
        currScreen.hide();
    }

    @Override
    public void dispose() {
        currScreen.dispose();
    }

    static {
        firstScreen = "";
        paused = false;
    }
}

