/*
 * Decompiled with CFR 0.152.
 */
package data;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import java.util.HashMap;

public class FontManager {
    static FreeTypeFontGenerator generator;
    static FreeTypeFontGenerator.FreeTypeFontParameter parameter;
    static HashMap<Integer, HashMap<Integer, BitmapFont>> fonts;
    static boolean initialize;
    static Color defaultColor;

    public static BitmapFont get(int size) {
        return FontManager.get(size, 0);
    }

    private static void initializeGenerator() {
        generator = new FreeTypeFontGenerator(Gdx.files.internal("helvetica-neue-bold.ttf"));
        parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
        initialize = false;
    }

    public static BitmapFont get(int size, int specialInstance) {
        if (initialize) {
            FontManager.initializeGenerator();
        }
        if (fonts.get(size) == null) {
            try {
                FontManager.parameter.size = size;
                FontManager.parameter.minFilter = Texture.TextureFilter.Linear;
                FontManager.parameter.magFilter = Texture.TextureFilter.Linear;
                fonts.put(size, new HashMap());
                fonts.get(size).put(specialInstance, generator.generateFont(parameter));
                fonts.get(size).get(specialInstance).setColor(defaultColor);
            }
            catch (Exception e) {
                System.out.println("Impossible de g\u00e9nerer cette taille (oui c'est WTF) : " + size);
                e.printStackTrace();
                System.exit(0);
            }
        }
        if (fonts.get(size).get(specialInstance) == null) {
            try {
                FontManager.parameter.size = size;
                FontManager.parameter.minFilter = Texture.TextureFilter.Linear;
                FontManager.parameter.magFilter = Texture.TextureFilter.Linear;
                fonts.get(size).put(specialInstance, generator.generateFont(parameter));
                fonts.get(size).get(specialInstance).setColor(defaultColor);
            }
            catch (Exception e) {
                System.out.println("Impossible de g\u00e9nerer cette taille (oui c'est WTF) : " + size);
                e.printStackTrace();
                System.exit(0);
            }
        }
        return fonts.get(size).get(specialInstance);
    }

    public static void setDefaultColor(Color c) {
        defaultColor = c;
    }

    public static void reload() {
        fonts.clear();
        FontManager.initializeGenerator();
    }

    public static BitmapFont getInstance(int size) {
        if (initialize) {
            FontManager.initializeGenerator();
        }
        FontManager.parameter.size = size;
        FontManager.parameter.minFilter = Texture.TextureFilter.Linear;
        FontManager.parameter.magFilter = Texture.TextureFilter.Linear;
        BitmapFont b = generator.generateFont(parameter);
        b.setColor(defaultColor);
        return b;
    }

    static {
        fonts = new HashMap();
        initialize = true;
        defaultColor = Color.BLACK;
    }
}

