/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.tabbedpane;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.I18NBundle;
import com.badlogic.gdx.utils.IdentityMap;
import com.badlogic.gdx.utils.Scaling;
import com.kotcrab.vis.ui.Locales;
import com.kotcrab.vis.ui.Sizes;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.i18n.BundleText;
import com.kotcrab.vis.ui.layout.DragPane;
import com.kotcrab.vis.ui.layout.HorizontalFlowGroup;
import com.kotcrab.vis.ui.layout.VerticalFlowGroup;
import com.kotcrab.vis.ui.util.dialog.Dialogs;
import com.kotcrab.vis.ui.util.dialog.OptionDialogAdapter;
import com.kotcrab.vis.ui.widget.Draggable;
import com.kotcrab.vis.ui.widget.VisImageButton;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.tabbedpane.Tab;
import com.kotcrab.vis.ui.widget.tabbedpane.TabbedPaneListener;

public class TabbedPane {
    private TabbedPaneStyle style;
    private Sizes sizes;
    private VisImageButton.VisImageButtonStyle sharedCloseActiveButtonStyle;
    private DragPane tabsPane;
    private VisTable mainTable;
    private Array<Tab> tabs;
    private IdentityMap<Tab, TabButtonTable> tabsButtonMap;
    private ButtonGroup<Button> group;
    private Tab activeTab;
    private Array<TabbedPaneListener> listeners;
    private boolean allowTabDeselect;

    public TabbedPane() {
        this(VisUI.getSkin().get(TabbedPaneStyle.class));
    }

    public TabbedPane(String styleName) {
        this(VisUI.getSkin().get(styleName, TabbedPaneStyle.class));
    }

    public TabbedPane(TabbedPaneStyle style) {
        this(style, VisUI.getSizes());
    }

    public TabbedPane(TabbedPaneStyle style, Sizes sizes) {
        this.style = style;
        this.sizes = sizes;
        this.listeners = new Array();
        this.sharedCloseActiveButtonStyle = VisUI.getSkin().get("close-active-tab", VisImageButton.VisImageButtonStyle.class);
        this.group = new ButtonGroup();
        this.mainTable = new VisTable();
        this.tabsPane = new DragPane(style.vertical ? new VerticalFlowGroup() : new HorizontalFlowGroup());
        this.configureDragPane(style);
        this.mainTable.setBackground(style.background);
        this.tabs = new Array();
        this.tabsButtonMap = new IdentityMap();
        Cell<DragPane> tabsPaneCell = this.mainTable.add(this.tabsPane);
        if (style.separatorBar != null) {
            if (style.vertical) {
                tabsPaneCell.top().growY().minSize(0.0f, 0.0f);
                this.mainTable.add(new Image(style.separatorBar)).grow().width(style.separatorBar.getMinWidth());
            } else {
                tabsPaneCell.left().growX().minSize(0.0f, 0.0f);
                this.mainTable.row();
                this.mainTable.add(new Image(style.separatorBar)).grow().height(style.separatorBar.getMinHeight());
            }
        } else {
            this.mainTable.add().expand().fill();
        }
    }

    private void configureDragPane(TabbedPaneStyle style) {
        this.tabsPane.setTouchable(Touchable.childrenOnly);
        this.tabsPane.setListener(new DragPane.DragPaneListener.AcceptOwnChildren());
        if (style.draggable) {
            Draggable draggable = new Draggable();
            draggable.setInvisibleWhenDragged(true);
            draggable.setKeepWithinParent(true);
            draggable.setBlockInput(true);
            draggable.setFadingTime(0.0f);
            this.tabsPane.setDraggable(draggable);
        }
    }

    public DragPane getTabsPane() {
        return this.tabsPane;
    }

    public void setAllowTabDeselect(boolean allowTabDeselect) {
        this.allowTabDeselect = allowTabDeselect;
        if (allowTabDeselect) {
            this.group.setMinCheckCount(0);
        } else {
            this.group.setMinCheckCount(1);
        }
    }

    public boolean isAllowTabDeselect() {
        return this.allowTabDeselect;
    }

    public void add(Tab tab) {
        tab.setPane(this);
        this.tabs.add(tab);
        this.addTab(tab, this.tabsPane.getChildren().size);
        this.switchTab(tab);
    }

    public void insert(int index, Tab tab) {
        tab.setPane(this);
        this.tabs.insert(index, tab);
        this.addTab(tab, index);
    }

    protected void addTab(Tab tab, int index) {
        TabButtonTable buttonTable = this.tabsButtonMap.get(tab);
        if (buttonTable == null) {
            buttonTable = new TabButtonTable(tab);
            this.tabsButtonMap.put(tab, buttonTable);
        }
        buttonTable.setTouchable(Touchable.enabled);
        if (index >= this.tabsPane.getChildren().size) {
            this.tabsPane.addActor(buttonTable);
        } else {
            this.tabsPane.addActorAt(index, buttonTable);
        }
        this.group.add(buttonTable.button);
        if (this.tabs.size == 1 && this.activeTab != null) {
            buttonTable.select();
            this.notifyListenersSwitched(tab);
        } else if (tab == this.activeTab) {
            buttonTable.select();
        }
    }

    public void disableTab(Tab tab, boolean disable) {
        this.checkIfTabsBelongsToThisPane(tab);
        TabButtonTable buttonTable = this.tabsButtonMap.get(tab);
        buttonTable.button.setDisabled(disable);
        if (this.activeTab == tab && disable) {
            if (this.selectFirstEnabledTab()) {
                return;
            }
            this.activeTab = null;
            this.notifyListenersSwitched(null);
        }
        if (this.activeTab == null && !this.allowTabDeselect) {
            this.selectFirstEnabledTab();
        }
    }

    public boolean isTabDisabled(Tab tab) {
        TabButtonTable table = this.tabsButtonMap.get(tab);
        if (table == null) {
            this.throwNotBelongingTabException(tab);
        }
        return table.button.isDisabled();
    }

    private boolean selectFirstEnabledTab() {
        for (IdentityMap.Entry<Tab, TabButtonTable> entry : this.tabsButtonMap) {
            if (((TabButtonTable)entry.value).button.isDisabled()) continue;
            this.switchTab((Tab)entry.key);
            return true;
        }
        return false;
    }

    private void checkIfTabsBelongsToThisPane(Tab tab) {
        if (!this.tabs.contains(tab, true)) {
            this.throwNotBelongingTabException(tab);
        }
    }

    protected void throwNotBelongingTabException(Tab tab) {
        throw new IllegalArgumentException("Tab '" + tab.getTabTitle() + "' does not belong to this TabbedPane");
    }

    public boolean remove(Tab tab) {
        return this.remove(tab, true);
    }

    public boolean remove(final Tab tab, boolean ignoreTabDirty) {
        this.checkIfTabsBelongsToThisPane(tab);
        if (ignoreTabDirty) {
            return this.removeTab(tab);
        }
        if (!tab.isDirty() || this.mainTable.getStage() == null) {
            return this.removeTab(tab);
        }
        Dialogs.showOptionDialog(this.mainTable.getStage(), Text.UNSAVED_DIALOG_TITLE.get(), Text.UNSAVED_DIALOG_TEXT.get(), Dialogs.OptionDialogType.YES_NO_CANCEL, new OptionDialogAdapter(){

            @Override
            public void yes() {
                tab.save();
                TabbedPane.this.removeTab(tab);
            }

            @Override
            public void no() {
                TabbedPane.this.removeTab(tab);
            }
        });
        return false;
    }

    private boolean removeTab(Tab tab) {
        int index = this.tabs.indexOf(tab, true);
        boolean success = this.tabs.removeValue(tab, true);
        if (success) {
            TabButtonTable buttonTable = this.tabsButtonMap.get(tab);
            this.tabsPane.removeActor(buttonTable, true);
            this.tabsPane.invalidateHierarchy();
            this.tabsButtonMap.remove(tab);
            tab.setPane(null);
            tab.onHide();
            tab.dispose();
            this.notifyListenersRemoved(tab);
            if (this.tabs.size == 0) {
                this.notifyListenersRemovedAll();
            } else if (this.activeTab == tab) {
                if (index > 0) {
                    this.switchTab(--index);
                } else {
                    this.switchTab(index);
                }
            }
        }
        return success;
    }

    public void removeAll() {
        for (Tab tab : this.tabs) {
            tab.setPane(null);
            tab.onHide();
            tab.dispose();
        }
        this.tabs.clear();
        this.tabsButtonMap.clear();
        this.tabsPane.clear();
        this.notifyListenersRemovedAll();
    }

    public void switchTab(int index) {
        this.tabsButtonMap.get(this.tabs.get(index)).select();
    }

    public void switchTab(Tab tab) {
        TabButtonTable table = this.tabsButtonMap.get(tab);
        if (table == null) {
            this.throwNotBelongingTabException(tab);
        }
        table.select();
    }

    public void updateTabTitle(Tab tab) {
        TabButtonTable table = this.tabsButtonMap.get(tab);
        if (table == null) {
            this.throwNotBelongingTabException(tab);
        }
        table.button.setText(this.getTabTitle(tab));
    }

    protected String getTabTitle(Tab tab) {
        return tab.isDirty() ? "*" + tab.getTabTitle() : tab.getTabTitle();
    }

    public Table getTable() {
        return this.mainTable;
    }

    public Tab getActiveTab() {
        return this.activeTab;
    }

    public void addListener(TabbedPaneListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(TabbedPaneListener listener) {
        return this.listeners.removeValue(listener, true);
    }

    private void notifyListenersSwitched(Tab tab) {
        for (TabbedPaneListener listener : this.listeners) {
            listener.switchedTab(tab);
        }
    }

    private void notifyListenersRemoved(Tab tab) {
        for (TabbedPaneListener listener : this.listeners) {
            listener.removedTab(tab);
        }
    }

    private void notifyListenersRemovedAll() {
        for (TabbedPaneListener listener : this.listeners) {
            listener.removedAllTabs();
        }
    }

    public Array<Tab> getTabs() {
        return this.tabs;
    }

    private static enum Text implements BundleText
    {
        UNSAVED_DIALOG_TITLE("unsavedDialogTitle"),
        UNSAVED_DIALOG_TEXT("unsavedDialogText");

        private final String name;

        private Text(String name) {
            this.name = name;
        }

        private static I18NBundle getBundle() {
            return Locales.getTabbedPaneBundle();
        }

        @Override
        public final String getName() {
            return this.name;
        }

        @Override
        public final String get() {
            return Text.getBundle().get(this.name);
        }

        @Override
        public final String format() {
            return Text.getBundle().format(this.name, new Object[0]);
        }

        @Override
        public final String format(Object ... arguments) {
            return Text.getBundle().format(this.name, arguments);
        }

        public final String toString() {
            return this.get();
        }
    }

    private class TabButtonTable
    extends VisTable {
        public VisTextButton button;
        public VisImageButton closeButton;
        private Tab tab;
        private VisTextButton.VisTextButtonStyle buttonStyle;
        private VisImageButton.VisImageButtonStyle closeButtonStyle;
        private Drawable up;

        public TabButtonTable(Tab tab) {
            this.tab = tab;
            this.button = new VisTextButton(TabbedPane.this.getTabTitle(tab), ((TabbedPane)TabbedPane.this).style.buttonStyle){

                @Override
                public void setDisabled(boolean isDisabled) {
                    super.setDisabled(isDisabled);
                    TabButtonTable.this.closeButton.setDisabled(isDisabled);
                    TabButtonTable.this.deselect();
                }
            };
            this.button.setFocusBorderEnabled(false);
            this.button.setProgrammaticChangeEvents(false);
            this.closeButtonStyle = new VisImageButton.VisImageButtonStyle(VisUI.getSkin().get("close", VisImageButton.VisImageButtonStyle.class));
            this.closeButton = new VisImageButton(this.closeButtonStyle);
            this.closeButton.setGenerateDisabledImage(true);
            this.closeButton.getImage().setScaling(Scaling.fill);
            this.closeButton.getImage().setColor(Color.RED);
            this.addListeners();
            this.buttonStyle = new VisTextButton.VisTextButtonStyle((VisTextButton.VisTextButtonStyle)this.button.getStyle());
            this.button.setStyle(this.buttonStyle);
            this.closeButtonStyle = this.closeButton.getStyle();
            this.up = this.buttonStyle.up;
            this.add(this.button);
            if (tab.isCloseableByUser()) {
                this.add(this.closeButton).size(14.0f * ((TabbedPane)TabbedPane.this).sizes.scaleFactor, this.button.getHeight());
            }
        }

        private void addListeners() {
            this.closeButton.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    TabButtonTable.this.closeTabAsUser();
                }
            });
            this.button.addListener(new InputListener(){
                private boolean isDown;

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int mouseButton) {
                    if (TabButtonTable.this.button.isDisabled()) {
                        return false;
                    }
                    this.isDown = true;
                    if (UIUtils.left()) {
                        this.setDraggedUpImage();
                    }
                    if (mouseButton == 2) {
                        TabButtonTable.this.closeTabAsUser();
                    }
                    return true;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    this.setDefaultUpImage();
                    this.isDown = false;
                }

                @Override
                public boolean mouseMoved(InputEvent event, float x, float y) {
                    if (!TabButtonTable.this.button.isDisabled() && TabbedPane.this.activeTab != TabButtonTable.this.tab) {
                        this.setCloseButtonOnMouseMove();
                    }
                    return false;
                }

                @Override
                public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                    if (!TabButtonTable.this.button.isDisabled() && !this.isDown && TabbedPane.this.activeTab != TabButtonTable.this.tab) {
                        this.setDefaultUpImage();
                    }
                }

                @Override
                public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                    if (!TabButtonTable.this.button.isDisabled() && TabbedPane.this.activeTab != TabButtonTable.this.tab && !Gdx.input.justTouched()) {
                        this.setCloseButtonOnMouseMove();
                    }
                }

                private void setCloseButtonOnMouseMove() {
                    ((TabButtonTable)TabButtonTable.this).closeButtonStyle.up = UIUtils.left() ? ((TabButtonTable)TabButtonTable.this).buttonStyle.down : ((TabButtonTable)TabButtonTable.this).buttonStyle.over;
                }

                private void setDraggedUpImage() {
                    ((TabButtonTable)TabButtonTable.this).closeButtonStyle.up = ((TabButtonTable)TabButtonTable.this).buttonStyle.down;
                    ((TabButtonTable)TabButtonTable.this).buttonStyle.up = ((TabButtonTable)TabButtonTable.this).buttonStyle.down;
                }

                private void setDefaultUpImage() {
                    ((TabButtonTable)TabButtonTable.this).closeButtonStyle.up = TabButtonTable.this.up;
                    ((TabButtonTable)TabButtonTable.this).buttonStyle.up = TabButtonTable.this.up;
                }
            });
            this.button.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    TabButtonTable.this.switchToNewTab();
                }
            });
        }

        private void switchToNewTab() {
            TabButtonTable table;
            if (TabbedPane.this.activeTab != null && TabbedPane.this.activeTab != this.tab && (table = (TabButtonTable)TabbedPane.this.tabsButtonMap.get(TabbedPane.this.activeTab)) != null) {
                table.deselect();
                TabbedPane.this.activeTab.onHide();
            }
            if (this.button.isChecked() && this.tab != TabbedPane.this.activeTab) {
                TabbedPane.this.activeTab = this.tab;
                TabbedPane.this.notifyListenersSwitched(this.tab);
                this.tab.onShow();
                this.closeButton.setStyle(TabbedPane.this.sharedCloseActiveButtonStyle);
            } else if (TabbedPane.this.group.getCheckedIndex() == -1) {
                TabbedPane.this.activeTab = null;
                TabbedPane.this.notifyListenersSwitched(null);
            }
        }

        private void closeTabAsUser() {
            if (this.tab.isCloseableByUser()) {
                TabbedPane.this.remove(this.tab, false);
            }
        }

        public void select() {
            this.button.setChecked(true);
            this.switchToNewTab();
        }

        public void deselect() {
            this.closeButton.setStyle(this.closeButtonStyle);
        }
    }

    public static class TabbedPaneStyle {
        public Drawable background;
        public VisTextButton.VisTextButtonStyle buttonStyle;
        public Drawable separatorBar;
        public boolean vertical = false;
        public boolean draggable = true;

        public TabbedPaneStyle() {
        }

        public TabbedPaneStyle(TabbedPaneStyle other) {
            this.background = other.background;
            this.buttonStyle = other.buttonStyle;
            this.separatorBar = other.separatorBar;
            this.vertical = other.vertical;
            this.draggable = other.draggable;
        }

        public TabbedPaneStyle(Drawable background, Drawable separatorBar, VisTextButton.VisTextButtonStyle buttonStyle) {
            this.background = background;
            this.separatorBar = separatorBar;
            this.buttonStyle = buttonStyle;
        }

        public TabbedPaneStyle(Drawable separatorBar, Drawable background, VisTextButton.VisTextButtonStyle buttonStyle, boolean vertical, boolean draggable) {
            this.separatorBar = separatorBar;
            this.background = background;
            this.buttonStyle = buttonStyle;
            this.vertical = vertical;
            this.draggable = draggable;
        }
    }
}

