/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.file.internal;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.kotcrab.vis.ui.util.dialog.Dialogs;
import com.kotcrab.vis.ui.util.dialog.OptionDialogAdapter;
import com.kotcrab.vis.ui.widget.MenuItem;
import com.kotcrab.vis.ui.widget.PopupMenu;
import com.kotcrab.vis.ui.widget.file.FileChooser;
import com.kotcrab.vis.ui.widget.file.FileChooserStyle;
import com.kotcrab.vis.ui.widget.file.FileUtils;
import com.kotcrab.vis.ui.widget.file.internal.FileChooserText;
import java.io.File;
import java.io.IOException;

public class FilePopupMenu
extends PopupMenu {
    private final FileChooserStyle style;
    private boolean trashAvailable;
    private FileHandle file;
    private MenuItem delete;
    private MenuItem newDirectory;
    private MenuItem showInExplorer;
    private MenuItem addToFavorites;
    private MenuItem removeFromFavorites;

    public FilePopupMenu(final FileChooser chooser, FileChooserStyle chooserStyle, final FilePopupMenuCallback callback) {
        super(chooserStyle.popupMenuStyleName);
        this.style = chooserStyle;
        this.delete = new MenuItem(FileChooserText.CONTEXT_MENU_DELETE.get(), this.style.iconTrash);
        this.newDirectory = new MenuItem(FileChooserText.CONTEXT_MENU_NEW_DIRECTORY.get(), this.style.iconFolderNew);
        this.showInExplorer = new MenuItem(FileChooserText.CONTEXT_MENU_SHOW_IN_EXPLORER.get());
        this.addToFavorites = new MenuItem(FileChooserText.CONTEXT_MENU_ADD_TO_FAVORITES.get(), this.style.iconFolderStar);
        this.removeFromFavorites = new MenuItem(FileChooserText.CONTEXT_MENU_REMOVE_FROM_FAVORITES.get(), this.style.iconFolderStar);
        this.delete.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Dialogs.showOptionDialog(chooser.getStage(), FileChooserText.POPUP_TITLE.get(), FilePopupMenu.this.trashAvailable ? FileChooserText.CONTEXT_MENU_MOVE_TO_TRASH_WARNING.get() : FileChooserText.CONTEXT_MENU_DELETE_WARNING.get(), Dialogs.OptionDialogType.YES_NO, new OptionDialogAdapter(){

                    @Override
                    public void yes() {
                        try {
                            boolean success = callback.delete(FilePopupMenu.this.file);
                            if (!success) {
                                Dialogs.showErrorDialog(FilePopupMenu.this.getStage(), FileChooserText.POPUP_DELETE_FILE_FAILED.get());
                            }
                        }
                        catch (IOException e) {
                            Dialogs.showErrorDialog(FilePopupMenu.this.getStage(), FileChooserText.POPUP_DELETE_FILE_FAILED.get(), e);
                            e.printStackTrace();
                        }
                        chooser.refresh();
                    }
                });
            }
        });
        this.newDirectory.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                callback.showNewDirDialog();
            }
        });
        this.showInExplorer.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                try {
                    FileUtils.showDirInExplorer(FilePopupMenu.this.file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.addToFavorites.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                chooser.addFavorite(FilePopupMenu.this.file);
            }
        });
        this.removeFromFavorites.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                chooser.removeFavorite(FilePopupMenu.this.file);
            }
        });
    }

    public void build() {
        this.clearChildren();
        this.addItem(this.newDirectory);
    }

    public void build(Array<FileHandle> favorites, FileHandle file) {
        this.file = file;
        this.clearChildren();
        this.addItem(this.newDirectory);
        this.addSeparator();
        if (file.type() == Files.FileType.Absolute || file.type() == Files.FileType.External) {
            this.addItem(this.delete);
        }
        if (file.type() == Files.FileType.Absolute) {
            this.addItem(this.showInExplorer);
            if (file.isDirectory()) {
                if (favorites.contains(file, false)) {
                    this.addItem(this.removeFromFavorites);
                } else {
                    this.addItem(this.addToFavorites);
                }
            }
        }
    }

    public void buildForFavorite(Array<FileHandle> favorites, File file) {
        this.file = Gdx.files.absolute(file.getAbsolutePath());
        this.clearChildren();
        this.addItem(this.showInExplorer);
        if (favorites.contains(this.file, false)) {
            this.addItem(this.removeFromFavorites);
        }
    }

    public void fileDeleterChanged(boolean trashAvailable) {
        this.trashAvailable = trashAvailable;
        this.delete.setText(trashAvailable ? FileChooserText.CONTEXT_MENU_MOVE_TO_TRASH.get() : FileChooserText.CONTEXT_MENU_DELETE.get());
    }

    public static interface FilePopupMenuCallback {
        public void showNewDirDialog();

        public boolean delete(FileHandle var1) throws IOException;
    }
}

