/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.file.internal;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;

public class FavoritesIO {
    private static final String DEFAULT_FAVORITES_PREFS_NAME = "com.kotcrab.vis.ui.widget.file.filechooser_favorites";
    private static String favoritesPrefsName = "com.kotcrab.vis.ui.widget.file.filechooser_favorites";
    private static String keyName = "favorites";
    private Preferences prefs;
    private Json json = new Json();

    public FavoritesIO() {
        this.prefs = Gdx.app.getPreferences(favoritesPrefsName);
    }

    public static String getFavoritesPrefsName() {
        return favoritesPrefsName;
    }

    public static void setFavoritesPrefsName(String favoritesPrefsName) {
        if (favoritesPrefsName == null) {
            throw new IllegalStateException("favoritesPrefsName can't be null");
        }
        FavoritesIO.favoritesPrefsName = favoritesPrefsName;
    }

    public Array<FileHandle> loadFavorites() {
        String data = this.prefs.getString(keyName, null);
        if (data == null) {
            return new Array<FileHandle>();
        }
        return this.json.fromJson(FavouriteData.class, data).toFileHandleArray();
    }

    public void saveFavorites(Array<FileHandle> favorites) {
        this.prefs.putString(keyName, this.json.toJson(new FavouriteData(favorites)));
        this.prefs.flush();
    }

    public void checkIfUsingDefaultName() {
        if (favoritesPrefsName.equals(DEFAULT_FAVORITES_PREFS_NAME)) {
            Gdx.app.log("VisUI", "Warning, using default favorites preference name for file chooser! (see FileChooser.setFavoritesPrefsName(String))");
        }
    }

    private static class FileHandleData {
        public Files.FileType type;
        public String path;

        public FileHandleData() {
        }

        public FileHandleData(FileHandle file) {
            this.type = file.type();
            this.path = file.path();
        }

        public FileHandle toFileHandle() {
            switch (this.type) {
                case Absolute: {
                    return Gdx.files.absolute(this.path);
                }
                case Classpath: {
                    return Gdx.files.classpath(this.path);
                }
                case External: {
                    return Gdx.files.external(this.path);
                }
                case Internal: {
                    return Gdx.files.internal(this.path);
                }
                case Local: {
                    return Gdx.files.local(this.path);
                }
            }
            throw new IllegalStateException("Unknown file type!");
        }
    }

    private static class FavouriteData {
        public Array<FileHandleData> data;

        public FavouriteData() {
        }

        public FavouriteData(Array<FileHandle> favourites) {
            this.data = new Array();
            for (FileHandle file : favourites) {
                this.data.add(new FileHandleData(file));
            }
        }

        public Array<FileHandle> toFileHandleArray() {
            Array<FileHandle> files = new Array<FileHandle>();
            for (FileHandleData fileData : this.data) {
                files.add(fileData.toFileHandle());
            }
            return files;
        }
    }
}

